/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.debug;

import com.intellij.lang.javascript.flex.debug.FlexValue;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlObjectEvaluator {
    private final FakeCompositeNode myRootNode;
    static final Font MONOSPACED_FONT;

    public XmlObjectEvaluator(@NotNull XValue value, @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/flex/debug/XmlObjectEvaluator", "<init>"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/lang/javascript/flex/debug/XmlObjectEvaluator", "<init>"));
        }
        this.myRootNode = new FakeCompositeNode(value, callback);
    }

    public void startEvaluation() {
        this.myRootNode.myValue.computeChildren((XCompositeNode)this.myRootNode);
    }

    static {
        Font font = UIUtil.getToolTipFont();
        MONOSPACED_FONT = new Font("Monospaced", 0, font == null ? 12 : font.getSize());
    }

    private static class FakeCompositeNode
    implements XCompositeNode {
        private final XValue myValue;
        private final XFullValueEvaluator.XFullValueEvaluationCallback myCallback;
        private final FakeCompositeNode myParent;
        private final List<FakeCompositeNode> myChildren;
        private static final String XML_MARKER = " class='XML@";
        private static final String XMLLIST_MARKER = " class='XMLList'";

        public FakeCompositeNode(@NotNull XValue value, @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/flex/debug/XmlObjectEvaluator$FakeCompositeNode", "<init>"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/lang/javascript/flex/debug/XmlObjectEvaluator$FakeCompositeNode", "<init>"));
            }
            this.myChildren = new ArrayList<FakeCompositeNode>();
            this.myValue = value;
            this.myCallback = callback;
            this.myParent = null;
        }

        private FakeCompositeNode(@NotNull XValue value, @NotNull FakeCompositeNode parent) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/flex/debug/XmlObjectEvaluator$FakeCompositeNode", "<init>"));
            }
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/flex/debug/XmlObjectEvaluator$FakeCompositeNode", "<init>"));
            }
            this.myChildren = new ArrayList<FakeCompositeNode>();
            this.myValue = value;
            this.myCallback = null;
            this.myParent = parent;
        }

        public void setAlreadySorted(boolean alreadySorted) {
        }

        public void addChildren(@NotNull XValueChildrenList children, boolean last) {
            if (children == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/lang/javascript/flex/debug/XmlObjectEvaluator$FakeCompositeNode", "addChildren"));
            }
            if (this.getRootNode().myCallback.isObsolete()) {
                return;
            }
            for (int i = 0; i < children.size(); ++i) {
                XValue value = children.getValue(i);
                FakeCompositeNode node = new FakeCompositeNode(value, this);
                this.myChildren.add(node);
                value.computeChildren((XCompositeNode)node);
            }
            this.getRootNode().myCallback.evaluated(this.getRootNode().toPresentableSting(0), MONOSPACED_FONT);
        }

        private FakeCompositeNode getRootNode() {
            FakeCompositeNode node = this;
            while (node.myCallback == null) {
                node = node.myParent;
            }
            return node;
        }

        private String toPresentableSting(int level) {
            int xmlInfoEndIndex;
            StringBuilder buffer = new StringBuilder();
            String rawText = ((FlexValue)this.myValue).getResult();
            if (rawText.contains(XMLLIST_MARKER)) {
                for (FakeCompositeNode child : this.myChildren) {
                    buffer.append(child.toPresentableSting(level));
                }
                return buffer.toString();
            }
            int xmlMarkerIndex = rawText.indexOf(XML_MARKER);
            int xmlInfoStartIndex = xmlMarkerIndex < 0 ? -1 : rawText.indexOf(" ", xmlMarkerIndex + XML_MARKER.length());
            int n = xmlInfoEndIndex = xmlMarkerIndex < 0 ? -1 : rawText.lastIndexOf("'");
            if (xmlInfoStartIndex > 0 && xmlInfoEndIndex > xmlInfoStartIndex) {
                boolean isText;
                String xmlInfo = rawText.substring(xmlInfoStartIndex, xmlInfoEndIndex);
                boolean isElement = xmlInfo.startsWith(" element <") && xmlInfo.endsWith(">");
                boolean isEmptyElement = isElement && xmlInfo.endsWith("/>");
                boolean bl = isText = !isElement && xmlInfo.startsWith(" text ");
                if (isText || isElement) {
                    if (isText) {
                        FakeCompositeNode.appendIndent(buffer, level);
                        buffer.append(xmlInfo.substring(" text ".length()));
                        buffer.append("\n");
                    } else if (isEmptyElement) {
                        FakeCompositeNode.appendIndent(buffer, level);
                        buffer.append(xmlInfo.substring(" element ".length()));
                        buffer.append("\n");
                    } else {
                        String startTag;
                        int spaceIndex = (startTag = xmlInfo.substring(" element ".length())).indexOf(" ");
                        String tagName = startTag.substring(1, spaceIndex > 0 ? spaceIndex : startTag.length() - 1);
                        FakeCompositeNode.appendIndent(buffer, level);
                        buffer.append(startTag);
                        buffer.append("\n");
                        for (FakeCompositeNode child : this.myChildren) {
                            buffer.append(child.toPresentableSting(level + 1));
                        }
                        FakeCompositeNode.appendIndent(buffer, level);
                        buffer.append("</").append(tagName).append("> ");
                        buffer.append("\n");
                    }
                }
            }
            return buffer.toString();
        }

        private static void appendIndent(StringBuilder buffer, int level) {
            for (int i = 0; i < level; ++i) {
                buffer.append("    ");
            }
        }

        public void tooManyChildren(int remaining) {
        }

        public void setErrorMessage(@NotNull String errorMessage) {
            if (errorMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/lang/javascript/flex/debug/XmlObjectEvaluator$FakeCompositeNode", "setErrorMessage"));
            }
        }

        public void setErrorMessage(@NotNull String errorMessage, @Nullable XDebuggerTreeNodeHyperlink link) {
            if (errorMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/lang/javascript/flex/debug/XmlObjectEvaluator$FakeCompositeNode", "setErrorMessage"));
            }
        }

        public void setMessage(@NotNull String message, Icon icon, @NotNull SimpleTextAttributes attributes, @Nullable XDebuggerTreeNodeHyperlink link) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/flex/debug/XmlObjectEvaluator$FakeCompositeNode", "setMessage"));
            }
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/lang/javascript/flex/debug/XmlObjectEvaluator$FakeCompositeNode", "setMessage"));
            }
        }

        public boolean isObsolete() {
            return false;
        }
    }
}

