/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.debug;

import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingMode;
import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingType;
import com.intellij.lang.javascript.flex.debug.DebuggerCommand;
import com.intellij.lang.javascript.flex.debug.FlexDebugProcess;
import com.intellij.lang.javascript.flex.debug.VMState;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.BidirectionalMap;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class KnownFilesInfo {
    private final FlexDebugProcess myFlexDebugProcess;
    private boolean myUpToDate = false;
    private final TIntObjectHashMap<BidirectionalMap<String, String>> myWorkerToFilePathToIdMap = new TIntObjectHashMap();
    private final TIntObjectHashMap<Map<String, Collection<String>>> myWorkerToFileNameToPathsMap = new TIntObjectHashMap();

    public KnownFilesInfo(FlexDebugProcess flexDebugProcess) {
        this.myFlexDebugProcess = flexDebugProcess;
    }

    public void setUpToDate(boolean upToDate) {
        this.myUpToDate = upToDate;
    }

    @Nullable
    public String getFilePathById(int worker, String id) {
        this.ensureUpToDate();
        BidirectionalMap filePathToId = (BidirectionalMap)this.myWorkerToFilePathToIdMap.get(worker);
        List paths = filePathToId == null ? null : filePathToId.getKeysByValue((Object)id);
        return paths != null && paths.size() > 0 ? (String)paths.get(0) : null;
    }

    @Nullable
    public String getIdByFilePath(String filePath) {
        this.ensureUpToDate();
        boolean worker = false;
        BidirectionalMap filePathToId = (BidirectionalMap)this.myWorkerToFilePathToIdMap.get(0);
        return filePathToId == null ? null : (String)filePathToId.get((Object)filePath);
    }

    @Nullable
    public String getIdByFilePathNoUpdate(String filePath) {
        boolean worker = false;
        BidirectionalMap filePathToId = (BidirectionalMap)this.myWorkerToFilePathToIdMap.get(0);
        return filePathToId == null ? null : (String)filePathToId.get((Object)filePath);
    }

    @Nullable
    public Collection<String> getPathsByName(int worker, String fileName) {
        this.ensureUpToDate();
        Map fileNameToPaths = (Map)this.myWorkerToFileNameToPathsMap.get(worker);
        return fileNameToPaths == null ? null : (Collection)fileNameToPaths.get(fileName);
    }

    private void ensureUpToDate() {
        if (this.myUpToDate) {
            return;
        }
        this.myFlexDebugProcess.sendAndProcessOneCommand(new DebuggerCommand("show files", CommandOutputProcessingType.SPECIAL_PROCESSING, VMState.SUSPENDED, VMState.SUSPENDED){

            @Override
            CommandOutputProcessingMode onTextAvailable(@NonNls String s) {
                KnownFilesInfo.this.processShowFilesResult(new StringTokenizer(s, "\r\n"));
                return CommandOutputProcessingMode.DONE;
            }
        }, null);
        this.myUpToDate = true;
    }

    private void processShowFilesResult(StringTokenizer tokenizer) {
        while (tokenizer.hasMoreTokens()) {
            BidirectionalMap filePathToIdMap;
            int nextSpaceIndex;
            String line = tokenizer.nextToken().trim();
            int spaceIndex = line.indexOf(32);
            int commaIndex = line.indexOf(", ");
            if (spaceIndex == -1 || commaIndex == -1) {
                FlexDebugProcess.log("Unexpected string format:" + line);
                continue;
            }
            String id = line.substring(0, spaceIndex);
            String fullPath = FileUtil.toSystemIndependentName((String)line.substring(spaceIndex + 1, commaIndex));
            int markerIndex = fullPath.indexOf("/frameworks/projects/");
            if (markerIndex != -1 && fullPath.indexOf("/src/", markerIndex) > 0) {
                fullPath = this.myFlexDebugProcess.getAppSdkHome() + fullPath.substring(markerIndex);
            }
            String shortName = (nextSpaceIndex = line.indexOf(32, commaIndex + 2)) > 0 ? line.substring(commaIndex + 2, nextSpaceIndex) : line.substring(commaIndex);
            int worker = 0;
            if (nextSpaceIndex > 0) {
                if ("(Main Thread)".equals(line.substring(nextSpaceIndex + 1))) {
                    worker = 0;
                } else if (line.substring(nextSpaceIndex + 1).startsWith("(Worker ") && line.endsWith(")")) {
                    try {
                        worker = Integer.parseInt(line.substring(nextSpaceIndex + 1 + "(Worker ".length(), line.length() - 1));
                    }
                    catch (NumberFormatException e) {
                        FlexDebugProcess.log("Unexpected string format:" + line);
                    }
                } else {
                    FlexDebugProcess.log("Unexpected string format:" + line);
                }
            }
            if ((filePathToIdMap = (BidirectionalMap)this.myWorkerToFilePathToIdMap.get(worker)) == null) {
                filePathToIdMap = new BidirectionalMap();
                this.myWorkerToFilePathToIdMap.put(worker, (Object)filePathToIdMap);
            }
            filePathToIdMap.put((Object)fullPath, (Object)id);
            Map fileNameToPaths = (Map)this.myWorkerToFileNameToPathsMap.get(worker);
            if (fileNameToPaths == null) {
                fileNameToPaths = new THashMap();
                this.myWorkerToFileNameToPathsMap.put(worker, (Object)fileNameToPaths);
            }
            KnownFilesInfo.addToMap(fileNameToPaths, shortName, fullPath);
        }
    }

    private static <K, T> void addToMap(Map<K, Collection<T>> map, K key, T valueCollectionElement) {
        Collection<T> valueCollection = map.get(key);
        if (valueCollection == null) {
            valueCollection = new ArrayList<T>(1);
            map.put(key, valueCollection);
        }
        if (!valueCollection.contains(valueCollectionElement)) {
            valueCollection.add(valueCollectionElement);
        }
    }
}

