/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.debug;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingMode;
import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingType;
import com.intellij.lang.javascript.flex.debug.CompositeDebuggerCommand;
import com.intellij.lang.javascript.flex.debug.DebuggerCommand;
import com.intellij.lang.javascript.flex.debug.FlexBreakpointType;
import com.intellij.lang.javascript.flex.debug.FlexDebugProcess;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexBreakpointsHandler {
    private static final ExtensionPointName<BreakpointTypeProvider> BREAKPOINT_TYPE_PROVIDER_EP = ExtensionPointName.create((String)"com.intellij.flex.breakpoint.type.provider");
    private final FlexDebugProcess myDebugProcess;
    private int lastBreakpointId;
    private final Collection<XBreakpointHandler<?>> myBreakpointHandlers;
    private final TObjectIntHashMap<XLineBreakpoint<XBreakpointProperties>> myBreakpointToIndexMap = new TObjectIntHashMap();
    private final TIntObjectHashMap<XLineBreakpoint<XBreakpointProperties>> myIndexToBreakpointMap = new TIntObjectHashMap();

    FlexBreakpointsHandler(FlexDebugProcess debugProcess) {
        this.myDebugProcess = debugProcess;
        this.myBreakpointHandlers = new ArrayList();
        this.myBreakpointHandlers.add(new MyBreakpointHandler(FlexBreakpointType.class));
        for (BreakpointTypeProvider provider : (BreakpointTypeProvider[])BREAKPOINT_TYPE_PROVIDER_EP.getExtensions()) {
            this.myBreakpointHandlers.add(new MyBreakpointHandler(provider.getBreakpointTypeClass()));
        }
    }

    void updateBreakpointStatusToInvalid(XLineBreakpoint<XBreakpointProperties> breakpoint) {
        if (breakpoint != null) {
            this.myDebugProcess.getSession().updateBreakpointPresentation(breakpoint, AllIcons.Debugger.Db_invalid_breakpoint, null);
        }
    }

    void updateBreakpointStatusToVerified(String breakPointNumber) {
        int index;
        XLineBreakpoint breakpoint;
        int spacePos = breakPointNumber.indexOf(32);
        if (spacePos != -1) {
            breakPointNumber = breakPointNumber.substring(0, spacePos);
        }
        if ((breakpoint = (XLineBreakpoint)this.myIndexToBreakpointMap.get(index = Integer.parseInt(breakPointNumber))) != null) {
            this.myDebugProcess.getSession().updateBreakpointPresentation(breakpoint, AllIcons.Debugger.Db_verified_breakpoint, null);
        }
    }

    private String buildInsertBreakpointCommandText(XSourcePosition sourcePosition) {
        String marker = this.myDebugProcess.resolveFileReference(sourcePosition.getFile());
        return "break " + marker + ":" + (sourcePosition.getLine() + 1);
    }

    void handleRunToPosition(XSourcePosition position, FlexDebugProcess flexDebugProcess) {
        flexDebugProcess.sendCommand(new CompositeDebuggerCommand(new InsertBreakpointCommand(this, position), new FlexDebugProcess.ContinueCommand()));
    }

    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        return this.myBreakpointHandlers.toArray(new XBreakpointHandler[this.myBreakpointHandlers.size()]);
    }

    XLineBreakpoint<XBreakpointProperties> getBreakpointByIndex(int breakpointId) {
        return (XLineBreakpoint)this.myIndexToBreakpointMap.get(breakpointId);
    }

    private static String getRemoveBreakpointCommandText(int breakPointIndex) {
        return "delete " + breakPointIndex;
    }

    class RemoveBreakpointCommand
    extends DebuggerCommand {
        private int myBreakpointIndex;
        private final XLineBreakpoint<XBreakpointProperties> myBreakpoint;
        private static final int UNKNOWN_ID = -1;
        final /* synthetic */ FlexBreakpointsHandler this$0;

        RemoveBreakpointCommand(FlexBreakpointsHandler this$0, @Nullable int breakPointIndex, XLineBreakpoint<XBreakpointProperties> breakpoint) {
            this.this$0 = this$0;
            super(FlexBreakpointsHandler.getRemoveBreakpointCommandText(breakPointIndex), CommandOutputProcessingType.SPECIAL_PROCESSING);
            this.myBreakpointIndex = breakPointIndex;
            this.myBreakpoint = breakpoint;
        }

        RemoveBreakpointCommand(@NotNull FlexBreakpointsHandler this$0, XLineBreakpoint<XBreakpointProperties> breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/lang/javascript/flex/debug/FlexBreakpointsHandler$RemoveBreakpointCommand", "<init>"));
            }
            this(this$0, -1, breakpoint);
        }

        @Override
        @NotNull
        String getText() {
            if (this.myBreakpointIndex == -1) {
                this.myBreakpointIndex = this.this$0.myBreakpointToIndexMap.get(this.myBreakpoint);
                String string = FlexBreakpointsHandler.getRemoveBreakpointCommandText(this.myBreakpointIndex);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/debug/FlexBreakpointsHandler$RemoveBreakpointCommand", "getText"));
                }
                return string;
            }
            String string = super.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/debug/FlexBreakpointsHandler$RemoveBreakpointCommand", "getText"));
            }
            return string;
        }

        @Override
        CommandOutputProcessingMode onTextAvailable(@NonNls String s) {
            this.this$0.myBreakpointToIndexMap.remove(this.myBreakpoint);
            this.this$0.myIndexToBreakpointMap.remove(this.myBreakpointIndex);
            return super.onTextAvailable(s);
        }
    }

    private class InsertBreakpointCommand
    extends DebuggerCommand {
        @Nullable
        private XLineBreakpoint<XBreakpointProperties> myBreakpoint;
        @NotNull
        private final XSourcePosition mySourcePosition;
        final /* synthetic */ FlexBreakpointsHandler this$0;

        InsertBreakpointCommand(@NotNull FlexBreakpointsHandler flexBreakpointsHandler, XSourcePosition sourcePosition) {
            if (sourcePosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePosition", "com/intellij/lang/javascript/flex/debug/FlexBreakpointsHandler$InsertBreakpointCommand", "<init>"));
            }
            this.this$0 = flexBreakpointsHandler;
            super(flexBreakpointsHandler.buildInsertBreakpointCommandText(sourcePosition), CommandOutputProcessingType.SPECIAL_PROCESSING);
            this.mySourcePosition = sourcePosition;
        }

        InsertBreakpointCommand(@NotNull FlexBreakpointsHandler flexBreakpointsHandler, XLineBreakpoint<XBreakpointProperties> _breakpoint) {
            if (_breakpoint == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_breakpoint", "com/intellij/lang/javascript/flex/debug/FlexBreakpointsHandler$InsertBreakpointCommand", "<init>"));
            }
            this(flexBreakpointsHandler, _breakpoint.getSourcePosition());
            this.myBreakpoint = _breakpoint;
        }

        @Override
        CommandOutputProcessingMode onTextAvailable(String s) {
            int index = s.indexOf("Breakpoint ");
            if (index != -1) {
                if (s.contains(" created")) {
                    this.registerBreakPoint();
                } else if (s.contains("not set; no executable code")) {
                    this.this$0.updateBreakpointStatusToInvalid(this.myBreakpoint);
                } else {
                    int from = index + "Breakpoint ".length();
                    if (s.contains("file")) {
                        this.registerBreakPoint();
                        this.this$0.updateBreakpointStatusToVerified(s.substring(from, s.indexOf(58, from)));
                    }
                }
            } else if (s.contains("Ambiguous matching file names:")) {
                if (this.this$0.myDebugProcess.getFileId(this.mySourcePosition.getFile().getPath()) != null) {
                    InsertBreakpointCommand command = this.myBreakpoint == null ? new InsertBreakpointCommand(this.this$0, this.mySourcePosition) : new InsertBreakpointCommand(this.this$0, this.myBreakpoint);
                    this.this$0.myDebugProcess.sendAndProcessOneCommand(command, null);
                } else {
                    this.this$0.updateBreakpointStatusToInvalid(this.myBreakpoint);
                }
            }
            return CommandOutputProcessingMode.DONE;
        }

        private void registerBreakPoint() {
            int breakPointIndex = ++this.this$0.lastBreakpointId;
            if (this.myBreakpoint != null) {
                this.this$0.myBreakpointToIndexMap.put(this.myBreakpoint, breakPointIndex);
                this.this$0.myIndexToBreakpointMap.put(breakPointIndex, this.myBreakpoint);
            }
        }
    }

    private class MyBreakpointHandler
    extends XBreakpointHandler<XLineBreakpoint<XBreakpointProperties>> {
        private MyBreakpointHandler(Class<? extends XBreakpointType<XLineBreakpoint<XBreakpointProperties>, ?>> breakpointTypeClass) {
            if (breakpointTypeClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpointTypeClass", "com/intellij/lang/javascript/flex/debug/FlexBreakpointsHandler$MyBreakpointHandler", "<init>"));
            }
            super(breakpointTypeClass);
        }

        public void registerBreakpoint(@NotNull XLineBreakpoint<XBreakpointProperties> breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/lang/javascript/flex/debug/FlexBreakpointsHandler$MyBreakpointHandler", "registerBreakpoint"));
            }
            XSourcePosition position = breakpoint.getSourcePosition();
            if (position != null && this.isValidSourceBreakpoint(position)) {
                FlexBreakpointsHandler.this.myDebugProcess.sendCommand(new InsertBreakpointCommand(FlexBreakpointsHandler.this, breakpoint));
            }
        }

        private boolean isValidSourceBreakpoint(XSourcePosition position) {
            VirtualFile file;
            Project project = FlexBreakpointsHandler.this.myDebugProcess.getSession().getProject();
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            VirtualFile rootForFile = fileIndex.getSourceRootForFile(file = position.getFile());
            if (rootForFile == null) {
                rootForFile = fileIndex.getClassRootForFile(file);
            }
            if (rootForFile == null) {
                return false;
            }
            Module module = FlexBreakpointsHandler.this.myDebugProcess.getModule();
            if (module == null) {
                return false;
            }
            ModuleWithDependenciesScope scope = FlexUtils.getModuleWithDependenciesAndLibrariesScope(module, FlexBreakpointsHandler.this.myDebugProcess.getBC(), FlexBreakpointsHandler.this.myDebugProcess.isFlexUnit());
            if (scope.contains(file) || this.isInSourcesOfLibraryInScope(fileIndex, file, (GlobalSearchScope)scope)) {
                return true;
            }
            if (DumbService.getInstance((Project)project).isDumb()) {
                return false;
            }
            String relPath = VfsUtilCore.getRelativePath((VirtualFile)file.getParent(), (VirtualFile)rootForFile, (char)'.');
            String fqn = StringUtil.getQualifiedName((String)relPath, (String)file.getNameWithoutExtension());
            PsiElement clazz = ActionScriptClassResolver.findClassByQNameStatic(fqn, (GlobalSearchScope)scope);
            return clazz == null || clazz.getContainingFile() instanceof PsiCompiledFile;
        }

        private boolean isInSourcesOfLibraryInScope(ProjectFileIndex fileIndex, VirtualFile file, GlobalSearchScope scope) {
            if (!fileIndex.isInLibrarySource(file)) {
                return false;
            }
            for (OrderEntry entry : fileIndex.getOrderEntriesForFile(file)) {
                VirtualFile[] classesRoots;
                for (VirtualFile root : classesRoots = entry.getFiles(OrderRootType.CLASSES)) {
                    if (!scope.contains(root)) continue;
                    return true;
                }
            }
            return false;
        }

        public void unregisterBreakpoint(@NotNull XLineBreakpoint<XBreakpointProperties> breakpoint, boolean temporary) {
            if (breakpoint == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/lang/javascript/flex/debug/FlexBreakpointsHandler$MyBreakpointHandler", "unregisterBreakpoint"));
            }
            XSourcePosition position = breakpoint.getSourcePosition();
            if (position != null && this.isValidSourceBreakpoint(position)) {
                FlexBreakpointsHandler.this.myDebugProcess.sendCommand(new RemoveBreakpointCommand(FlexBreakpointsHandler.this, breakpoint));
            }
        }
    }

    public static interface BreakpointTypeProvider {
        public Class<? extends XBreakpointType<XLineBreakpoint<XBreakpointProperties>, ?>> getBreakpointTypeClass();
    }
}

