/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.openapi.util.Pair;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;

public class NamespacesXmlBuilder
extends NanoXmlUtil.BaseXmlBuilder {
    private static final String INCLUDE_NAMESPACES_URI_LOCATION = NanoXmlUtil.createLocation((String[])new String[]{"flex-config", "include-namespaces", "uri"});
    private static final String NAMESPACE_LOCATION = NanoXmlUtil.createLocation((String[])new String[]{"flex-config", "compiler", "namespaces", "namespace"});
    private static final String NAMESPACE_URI_LOCATION = NanoXmlUtil.createLocation((String[])new String[]{"flex-config", "compiler", "namespaces", "namespace", "uri"});
    private static final String MANIFEST_LOCATION = NanoXmlUtil.createLocation((String[])new String[]{"flex-config", "compiler", "namespaces", "namespace", "manifest"});
    private Collection<String> myIncludedNamespaces = new ArrayList<String>();
    private Collection<Pair<String, String>> myNamespacesAndManifests = new ArrayList<Pair<String, String>>();
    private StringBuilder myNamespaceUri = new StringBuilder();
    private StringBuilder myManifest = new StringBuilder();

    public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
        super.startElement(name, nsPrefix, nsURI, systemID, lineNr);
        String location = this.getLocation();
        if (NAMESPACE_LOCATION.equals(location)) {
            this.myNamespaceUri.delete(0, this.myNamespaceUri.length());
            this.myManifest.delete(0, this.myManifest.length());
        } else if (NAMESPACE_URI_LOCATION.equals(location)) {
            this.myNamespaceUri.delete(0, this.myNamespaceUri.length());
        } else if (MANIFEST_LOCATION.equals(location)) {
            this.myManifest.delete(0, this.myManifest.length());
        }
    }

    public void addPCData(Reader reader, String systemID, int lineNr) throws Exception {
        String location = this.getLocation();
        if (INCLUDE_NAMESPACES_URI_LOCATION.equals(location)) {
            this.myIncludedNamespaces.add(NamespacesXmlBuilder.readText((Reader)reader));
        } else if (NAMESPACE_URI_LOCATION.equals(location)) {
            this.myNamespaceUri.append(NamespacesXmlBuilder.readText((Reader)reader));
        } else if (MANIFEST_LOCATION.equals(location)) {
            this.myManifest.append(NamespacesXmlBuilder.readText((Reader)reader));
        }
    }

    public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
        if (NAMESPACE_LOCATION.equals(this.getLocation())) {
            String uri = this.myNamespaceUri.toString().trim();
            String manifest = this.myManifest.toString().trim();
            if (uri.length() > 0 && manifest.length() > 0) {
                this.myNamespacesAndManifests.add((Pair<String, String>)Pair.create((Object)uri, (Object)manifest));
            }
        }
        super.endElement(name, nsPrefix, nsURI);
    }

    public Collection<String> getIncludedNamespaces() {
        return this.myIncludedNamespaces;
    }

    public Collection<Pair<String, String>> getNamespacesAndManifests() {
        return this.myNamespacesAndManifests;
    }
}

