/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.Nullable;

public class InfoFromConfigFile {
    public static final InfoFromConfigFile DEFAULT = new InfoFromConfigFile(null, null, null, null, null);
    @Nullable
    private final VirtualFile myConfigFile;
    @Nullable
    private final String myMainClassPath;
    private boolean myMainClassInitialized = false;
    @Nullable
    private String myMainClass;
    @Nullable
    private final String myOutputFileName;
    @Nullable
    private final String myOutputFolderPath;
    @Nullable
    private final String myTargetPlayer;

    InfoFromConfigFile(@Nullable VirtualFile configFile, @Nullable String mainClassPath, @Nullable String outputFileName, @Nullable String outputFolderPath, @Nullable String targetPlayer) {
        this.myConfigFile = configFile;
        this.myMainClassPath = mainClassPath;
        this.myOutputFileName = outputFileName;
        this.myOutputFolderPath = outputFolderPath;
        this.myTargetPlayer = targetPlayer;
    }

    @Nullable
    public String getMainClass(Module module) {
        if (!this.myMainClassInitialized && this.myConfigFile != null && this.myConfigFile.isValid()) {
            this.myMainClass = this.myMainClassPath == null ? null : InfoFromConfigFile.getClassForOutputTagValue(module, this.myMainClassPath, this.myConfigFile.getParent());
        }
        this.myMainClassInitialized = true;
        return this.myMainClass;
    }

    @Nullable
    public String getOutputFileName() {
        return this.myOutputFileName;
    }

    @Nullable
    public String getOutputFolderPath() {
        return this.myOutputFolderPath;
    }

    @Nullable
    public String getTargetPlayer() {
        return this.myTargetPlayer;
    }

    private static String getClassForOutputTagValue(Module module, String outputTagValue, VirtualFile baseDir) {
        if (outputTagValue.isEmpty()) {
            return "unknown";
        }
        VirtualFile file = VfsUtil.findRelativeFile((String)outputTagValue, (VirtualFile)baseDir);
        if (file == null) {
            return FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)outputTagValue));
        }
        VirtualFile sourceRoot = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex().getSourceRootForFile(file);
        if (sourceRoot == null) {
            return file.getNameWithoutExtension();
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)sourceRoot, (char)'/');
        return relativePath == null ? file.getNameWithoutExtension() : FileUtil.getNameWithoutExtension((String)relativePath).replace("/", ".");
    }
}

