/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.compiler.impl.BuildTargetScopeProvider;
import com.intellij.flex.build.FlexResourceBuildTargetType;
import com.intellij.lang.javascript.flex.build.FlexBuildTargetScopeProvider;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;

public class FlexResourceBuildTargetScopeProvider
extends BuildTargetScopeProvider {
    private static final Key<Collection<Pair<Module, FlexBuildConfiguration>>> MODULES_AND_BCS_TO_COMPILE = Key.create((String)"modules.and.bcs.to.compile");

    public static void setBCsToCompileForPackaging(CompileScope scope, Collection<Pair<Module, FlexBuildConfiguration>> bcs) {
        scope.putUserData(MODULES_AND_BCS_TO_COMPILE, bcs);
    }

    @Nullable
    public static Collection<Pair<Module, FlexBuildConfiguration>> getBCsToCompileForPackaging(CompileScope scope) {
        return (Collection)scope.getUserData(MODULES_AND_BCS_TO_COMPILE);
    }

    @NotNull
    public List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> getBuildTargetScopes(@NotNull CompileScope baseScope, @NotNull CompilerFilter filter, @NotNull Project project, boolean forceBuild) {
        if (baseScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseScope", "com/intellij/lang/javascript/flex/build/FlexResourceBuildTargetScopeProvider", "getBuildTargetScopes"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/lang/javascript/flex/build/FlexResourceBuildTargetScopeProvider", "getBuildTargetScopes"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/build/FlexResourceBuildTargetScopeProvider", "getBuildTargetScopes"));
        }
        ArrayList<String> moduleNames = new ArrayList<String>();
        try {
            for (Pair<Module, FlexBuildConfiguration> moduleAndBC : FlexBuildTargetScopeProvider.getModulesAndBCsToCompile(baseScope)) {
                moduleNames.add(((Module)moduleAndBC.first).getName());
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> list = Arrays.asList(CmdlineProtoUtil.createTargetsScope((String)FlexResourceBuildTargetType.PRODUCTION.getTypeId(), moduleNames, (boolean)forceBuild), CmdlineProtoUtil.createTargetsScope((String)FlexResourceBuildTargetType.TEST.getTypeId(), moduleNames, (boolean)forceBuild));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/build/FlexResourceBuildTargetScopeProvider", "getBuildTargetScopes"));
        }
        return list;
    }
}

