/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.projectStructure.model.AirDesktopPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.AirPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.AndroidPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.IosPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.ui.AirDesktopPackagingConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.AirPackagingConfigurableBase;
import com.intellij.lang.javascript.flex.projectStructure.ui.AndroidPackagingConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.CompilerOptionsConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.DependenciesConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.FlexBCConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.IOSPackagingConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import org.jetbrains.annotations.Nullable;

public class FlashProjectStructureProblem {
    public final ProjectStructureProblemType.Severity severity;
    public final String errorMessage;
    public final String errorId;
    public final String tabName;
    @Nullable
    public final Object locationOnTab;

    private FlashProjectStructureProblem(ProjectStructureProblemType.Severity severity, String errorMessage, String errorId, String tabName, @Nullable Object locationOnTab) {
        this.severity = severity;
        this.errorMessage = errorMessage;
        this.errorId = errorId;
        this.tabName = tabName;
        this.locationOnTab = locationOnTab;
    }

    public static FlashProjectStructureProblem createGeneralOptionProblem(ProjectStructureProblemType.Severity severity, String bcName, String errorMessage, FlexBCConfigurable.Location location) {
        return new FlashProjectStructureProblem(severity, errorMessage, location.errorId, bcName, (Object)location);
    }

    public static FlashProjectStructureProblem createDependenciesProblem(ProjectStructureProblemType.Severity severity, String errorMessage, DependenciesConfigurable.Location location) {
        return new FlashProjectStructureProblem(severity, errorMessage, location.errorId, DependenciesConfigurable.TAB_NAME, location);
    }

    public static FlashProjectStructureProblem createCompilerOptionsProblem(ProjectStructureProblemType.Severity severity, String errorMessage, CompilerOptionsConfigurable.Location location) {
        return new FlashProjectStructureProblem(severity, errorMessage, location.errorId, CompilerOptionsConfigurable.TAB_NAME, (Object)location);
    }

    public static FlashProjectStructureProblem createPackagingOptionsProblem(ProjectStructureProblemType.Severity severity, AirPackagingOptions packagingOptions, String errorMessage, AirPackagingConfigurableBase.Location location) {
        String tabName;
        String string = packagingOptions instanceof AirDesktopPackagingOptions ? AirDesktopPackagingConfigurable.TAB_NAME : (packagingOptions instanceof AndroidPackagingOptions ? AndroidPackagingConfigurable.TAB_NAME : (tabName = packagingOptions instanceof IosPackagingOptions ? IOSPackagingConfigurable.TAB_NAME : null));
        assert (tabName != null) : packagingOptions;
        return new FlashProjectStructureProblem(severity, errorMessage, location.errorId, tabName, (Object)location);
    }

    public static class FlexUnitOutputFolderProblem
    extends FlashProjectStructureProblem {
        public static final FlexUnitOutputFolderProblem INSTANCE = new FlexUnitOutputFolderProblem();

        private FlexUnitOutputFolderProblem() {
            super(ProjectStructureProblemType.Severity.ERROR, FlexBundle.message("flexunit.output.folder.not.set", new Object[0]), "project-output", "", null);
        }
    }
}

