/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.lang.javascript.flex.build.NoBackgroundBooleanTableCellRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.Nullable;

public abstract class AddRemoveTableRowsDialog<T>
extends DialogWrapper {
    protected final Project myProject;
    private final List<T> myList;
    private JPanel myMainPanel;
    protected JTable myTable;
    private boolean myEditAddedRow = false;

    public AddRemoveTableRowsDialog(Project project, String title, List<T> list) {
        super(project);
        this.myProject = project;
        this.myList = list;
        this.setTitle(title);
    }

    protected void init() {
        this.myMainPanel = new JPanel(new BorderLayout());
        this.initTable();
        this.initButtons();
        super.init();
    }

    protected void initTable() {
        this.myTable = new JBTable();
        this.myTable.setRowHeight(new JTextField((String)"Fake").getPreferredSize().height + this.myTable.getRowMargin());
        this.myTable.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)400, (int)150));
        this.myTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.myTable.setModel(this.createTableModel());
        this.myTable.setDefaultRenderer(Boolean.class, new NoBackgroundBooleanTableCellRenderer());
        TableColumnModel columnModel = this.myTable.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setPreferredWidth(this.getPreferredColumnWidth(i));
        }
    }

    protected abstract TableModelBase createTableModel();

    protected int getPreferredColumnWidth(int columnIndex) {
        return this.myTable.getColumnClass(columnIndex) == Boolean.class ? 50 : 200;
    }

    private void initButtons() {
        ToolbarDecorator d = ToolbarDecorator.createDecorator((JTable)this.myTable);
        d.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                if (AddRemoveTableRowsDialog.this.addObject()) {
                    ((AbstractTableModel)AddRemoveTableRowsDialog.this.myTable.getModel()).fireTableDataChanged();
                    if (AddRemoveTableRowsDialog.this.myEditAddedRow) {
                        AddRemoveTableRowsDialog.this.myTable.editCellAt(AddRemoveTableRowsDialog.this.myTable.getRowCount() - 1, 0);
                    }
                }
            }
        });
        d.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                TableUtil.stopEditing((JTable)AddRemoveTableRowsDialog.this.myTable);
                int[] selectedRows = AddRemoveTableRowsDialog.this.myTable.getSelectedRows();
                Arrays.sort(selectedRows);
                for (int i = selectedRows.length - 1; i >= 0; --i) {
                    AddRemoveTableRowsDialog.this.myList.remove(selectedRows[i]);
                }
                ((AbstractTableModel)AddRemoveTableRowsDialog.this.myTable.getModel()).fireTableDataChanged();
            }
        });
        this.myMainPanel.add((Component)d.createPanel(), "Center");
    }

    public void setEditAddedRow(boolean editAddedRow) {
        this.myEditAddedRow = editAddedRow;
    }

    protected abstract boolean addObject();

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    protected void doOKAction() {
        TableCellEditor cellEditor = this.myTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        super.doOKAction();
    }

    public List<T> getCurrentList() {
        return this.myList;
    }

    protected abstract class TableModelBase
    extends DefaultTableModel {
        protected TableModelBase() {
        }

        @Override
        public abstract int getColumnCount();

        @Override
        public int getRowCount() {
            return AddRemoveTableRowsDialog.this.myList.size();
        }

        @Override
        @Nullable
        public abstract String getColumnName(int var1);

        public abstract Class getColumnClass(int var1);

        @Override
        public Object getValueAt(int row, int column) {
            return this.getValue(AddRemoveTableRowsDialog.this.myList.get(row), column);
        }

        protected abstract Object getValue(T var1, int var2);

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            this.setValue(AddRemoveTableRowsDialog.this.myList.get(row), column, aValue);
        }

        protected abstract void setValue(T var1, int var2, Object var3);
    }
}

