/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.artifacts;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.SourceItemPresentation;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FlashBCOutputSourceItem
extends PackagingSourceItem {
    private final FlexBuildConfiguration myBc;
    private final Type myType;
    private final int myOrderNumber;

    public FlashBCOutputSourceItem(FlexBuildConfiguration bc, Type type, int number) {
        this.myBc = bc;
        this.myType = type;
        this.myOrderNumber = number;
    }

    public boolean equals(Object o) {
        return o instanceof FlashBCOutputSourceItem && this.myBc.equals(((FlashBCOutputSourceItem)((Object)o)).myBc) && this.myType.equals((Object)((FlashBCOutputSourceItem)((Object)o)).myType);
    }

    public int hashCode() {
        return this.myBc.hashCode() + this.myType.hashCode() * 239;
    }

    public SourceItemPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/flex/artifacts/FlashBCOutputSourceItem", "createPresentation"));
        }
        return new SourceItemPresentation(){

            public String getPresentableName() {
                switch (FlashBCOutputSourceItem.this.myType) {
                    case OutputFile: {
                        return FlexBundle.message("bc.output.file.source.item", FlashBCOutputSourceItem.this.myBc.getName(), PathUtil.getFileName((String)FlashBCOutputSourceItem.this.myBc.getActualOutputFilePath()));
                    }
                    case OutputFileAndHtmlWrapper: {
                        return FlexBundle.message("bc.output.file.and.wrapper.source.item", FlashBCOutputSourceItem.this.myBc.getName());
                    }
                    case OutputFolderContents: {
                        return FlexBundle.message("bc.output.folder.source.item", FlashBCOutputSourceItem.this.myBc.getName());
                    }
                }
                assert (false);
                return "";
            }

            public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
                if (presentationData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationData", "com/intellij/lang/javascript/flex/artifacts/FlashBCOutputSourceItem$1", "render"));
                }
                presentationData.setIcon(FlashBCOutputSourceItem.this.myBc.getIcon());
                presentationData.addText(this.getPresentableName(), mainAttributes);
            }

            public int getWeight() {
                return -FlashBCOutputSourceItem.this.myOrderNumber;
            }
        };
    }

    @NotNull
    public List<? extends PackagingElement<?>> createElements(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/flex/artifacts/FlashBCOutputSourceItem", "createElements"));
        }
        String outputFilePath = this.myBc.getActualOutputFilePath();
        String outputFolderPath = PathUtil.getParentPath((String)outputFilePath);
        switch (this.myType) {
            case OutputFile: {
                List<FileCopyPackagingElement> list = Collections.singletonList(new FileCopyPackagingElement(outputFilePath));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/artifacts/FlashBCOutputSourceItem", "createElements"));
                }
                return list;
            }
            case OutputFileAndHtmlWrapper: {
                ArrayList<Object> result = new ArrayList<Object>();
                result.add(new FileCopyPackagingElement(outputFilePath));
                result.add(new FileCopyPackagingElement(outputFolderPath + "/" + BCUtils.getWrapperFileName(this.myBc)));
                VirtualFile wrapperDir = LocalFileSystem.getInstance().findFileByPath(this.myBc.getWrapperTemplatePath());
                if (wrapperDir != null && wrapperDir.isDirectory()) {
                    for (VirtualFile file : wrapperDir.getChildren()) {
                        if ("index.template.html".equals(file.getName())) continue;
                        if (file.isDirectory()) {
                            DirectoryCopyPackagingElement packagingElement = new DirectoryCopyPackagingElement(outputFolderPath + "/" + file.getName());
                            result.add(PackagingElementFactory.getInstance().createParentDirectories(file.getName(), (PackagingElement)packagingElement));
                            continue;
                        }
                        result.add(new FileCopyPackagingElement(outputFolderPath + "/" + file.getName()));
                    }
                }
                ArrayList<Object> arrayList = result;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/artifacts/FlashBCOutputSourceItem", "createElements"));
                }
                return arrayList;
            }
            case OutputFolderContents: {
                List<DirectoryCopyPackagingElement> list = Collections.singletonList(new DirectoryCopyPackagingElement(outputFolderPath));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/artifacts/FlashBCOutputSourceItem", "createElements"));
                }
                return list;
            }
        }
        assert (false);
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/artifacts/FlashBCOutputSourceItem", "createElements"));
        }
        return list;
    }

    static enum Type {
        OutputFile,
        OutputFileAndHtmlWrapper,
        OutputFolderContents;

    }
}

