/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.actions.newfile;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.actions.newfile.CreateFlexComponentFix;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.ui.newclass.MainStep;
import com.intellij.lang.javascript.ui.newclass.WizardModel;
import com.intellij.lang.javascript.validation.fixes.CreateClassOrInterfaceFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.Properties;
import org.apache.velocity.runtime.parser.ParseException;

public class FlexMainStep
extends MainStep {
    private final WizardModel myModel;

    public FlexMainStep(WizardModel model, PsiElement context, String className, String packageName, String templateName) {
        super(model, context.getProject(), className, true, packageName, null, true, templateName, context, JSBundle.message((String)"choose.base.component.title", (Object[])new Object[0]), () -> CreateFlexComponentFix.computeApplicableTemplates(context));
        this.myModel = model;
        this.setSuperclassLabelText(FlexBundle.message("parent.component.label.text", new Object[0]));
    }

    protected boolean canFinish() {
        if (!super.canFinish()) {
            return false;
        }
        if (this.isSuperclassFieldEnabled()) {
            if (!JSUtils.isValidClassName((String)this.getSuperclassFqn(), (boolean)true)) {
                return false;
            }
            if (!(ActionScriptClassResolver.findClassByQNameStatic(this.getSuperclassFqn(), this.getSuperclassScope()) instanceof JSClass)) {
                return false;
            }
        }
        return true;
    }

    protected boolean canBeSuperClass(JSClass jsClass) {
        return super.canBeSuperClass(jsClass);
    }

    public void commit(AbstractWizardStepEx.CommitType commitType) throws CommitStepException {
        super.commit(commitType);
        try {
            FileTemplate template = (FileTemplate)ClassLoaderUtil.runWithClassLoader((ClassLoader)CreateClassOrInterfaceFix.class.getClassLoader(), (ThrowableComputable)new ThrowableComputable<FileTemplate, IOException>(){

                public FileTemplate compute() throws IOException {
                    return FileTemplateManager.getDefaultInstance().getInternalTemplate(FlexMainStep.this.myModel.getTemplateName());
                }
            });
            String[] attributes = FileTemplateUtil.calculateAttributes((String)template.getText(), (Properties)new Properties(), (boolean)true, (Project)this.myProject);
            if (ArrayUtil.contains((String)"Superclass", (String[])attributes)) {
                this.myModel.setSuperclassFqn(this.getSuperclassFqn());
            }
        }
        catch (IOException iOException) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }
}

