/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.actions.airpackage;

import com.intellij.lang.javascript.flex.actions.airpackage.PasswordStore;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Transient;

@State(name="AirPackageProjectParameters", storages={@Storage(value="$WORKSPACE_FILE$")})
public class AirPackageProjectParameters
implements PersistentStateComponent<AirPackageProjectParameters> {
    private static final String NATIVE_INSTALLER_EXTENSION = SystemInfo.isWindows ? ".exe" : (SystemInfo.isMac ? ".dmg" : (SystemInfo.OS_NAME.toLowerCase().contains("ubuntu") ? ".deb" : ".rpm"));
    public DesktopPackageType desktopPackageType = DesktopPackageType.values()[0];
    public AndroidPackageType androidPackageType = AndroidPackageType.values()[0];
    public boolean apkCaptiveRuntime = true;
    public int apkDebugListenPort = 7936;
    public IOSPackageType iosPackageType = IOSPackageType.values()[0];
    public boolean iosFastPackaging = true;
    public String deselectedBCs = "";
    private boolean myPackagingInProgress = false;
    @Transient
    private PasswordStore myPasswordStore = new PasswordStore();

    public static AirPackageProjectParameters getInstance(Project project) {
        return (AirPackageProjectParameters)ServiceManager.getService((Project)project, AirPackageProjectParameters.class);
    }

    public static PasswordStore getPasswordStore(Project project) {
        return AirPackageProjectParameters.getInstance((Project)project).myPasswordStore;
    }

    public AirPackageProjectParameters getState() {
        return this;
    }

    public void loadState(AirPackageProjectParameters state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    @Transient
    public void setPackagingInProgress(boolean packagingInProgress) {
        this.myPackagingInProgress = packagingInProgress;
    }

    @Transient
    public boolean isPackagingInProgress() {
        return this.myPackagingInProgress;
    }

    static /* synthetic */ String access$000() {
        return NATIVE_INSTALLER_EXTENSION;
    }

    public static enum IOSPackageType {
        Test("test without debugging"),
        DebugOverUSB("debug over USB"),
        DebugOverNetwork("debug over network"),
        TestOnSimulator("test on iOS Simulator"),
        DebugOnSimulator("debug on iOS Simulator"),
        AdHoc("ad hoc distribution"),
        AppStore("Apple App Store distribution");

        private final String myPresentableName;

        private IOSPackageType(String presentableName) {
            this.myPresentableName = presentableName;
        }

        public String toString() {
            return this.myPresentableName;
        }
    }

    public static enum AndroidPackageType {
        Release("release"),
        DebugOverUSB("debug over USB"),
        DebugOverNetwork("debug over network");

        private final String myPresentableName;

        private AndroidPackageType(String presentableName) {
            this.myPresentableName = presentableName;
        }

        public String toString() {
            return this.myPresentableName;
        }
    }

    public static enum DesktopPackageType {
        AirInstaller("installer (*.air)", ".air"),
        NativeInstaller("native installer (*" + AirPackageProjectParameters.access$000() + ")", AirPackageProjectParameters.access$000()),
        CaptiveRuntimeBundle("captive runtime bundle" + (SystemInfo.isMac ? " (*.app)" : ""), SystemInfo.isMac ? ".app" : ""),
        Airi("unsigned package (*.airi)", ".airi");

        private final String myPresentableName;
        private final String myFileExtension;

        private DesktopPackageType(String presentableName, String extension) {
            this.myPresentableName = presentableName;
            this.myFileExtension = extension;
        }

        public String toString() {
            return this.myPresentableName;
        }

        public String getFileExtension() {
            return this.myFileExtension;
        }
    }
}

