/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.lang.javascript.flex.JSFlexFileReference;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ReferenceSupport {
    public static boolean ALLOW_ABSOLUTE_REFERENCES_IN_TESTS = true;

    public static PsiReference[] getFileRefs(PsiElement elt, PsiElement valueNode, int offset, LookupOptions lookupOptions) {
        String str = StringUtil.stripQuotesAroundValue((String)valueNode.getText());
        return ReferenceSupport.getFileRefs(elt, offset, str, lookupOptions);
    }

    public static PsiReference[] getFileRefs(@NotNull PsiElement elt, int offset, String str, final LookupOptions lookupOptions) {
        int hashIndex;
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/lang/javascript/flex/ReferenceSupport", "getFileRefs"));
        }
        if (lookupOptions.IGNORE_TEXT_AFTER_HASH && (hashIndex = str.indexOf(35)) != -1) {
            str = str.substring(0, hashIndex);
        }
        final RelativeToWhat relativeToWhat = ReferenceSupport.relativeToWhat(str, elt, lookupOptions);
        final boolean startsWithSlash = str.startsWith("/");
        FileReferenceSet base = new FileReferenceSet(str, elt, offset, null, SystemInfo.isFileSystemCaseSensitive){

            public boolean isAbsolutePathReference() {
                return relativeToWhat == RelativeToWhat.Absolute;
            }

            public boolean couldBeConvertedTo(boolean relative) {
                return (relative && lookupOptions.RELATIVE_TO_FILE || !relative && lookupOptions.ABSOLUTE) && super.couldBeConvertedTo(relative);
            }

            public FileReference createFileReference(TextRange range, int index, String text) {
                return new JSFlexFileReference(this, range, index, text, relativeToWhat);
            }

            @NotNull
            public Collection<PsiFileSystemItem> computeDefaultContexts() {
                PsiFile psiFile = this.getContainingFile();
                if (psiFile == null) {
                    List<PsiFileSystemItem> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/ReferenceSupport$1", "computeDefaultContexts"));
                    }
                    return list;
                }
                PsiElement context = psiFile.getContext();
                if (context instanceof PsiLanguageInjectionHost) {
                    psiFile = context.getContainingFile();
                }
                psiFile = psiFile.getOriginalFile();
                ArrayList<VirtualFile> dirs = new ArrayList<VirtualFile>();
                if (lookupOptions.RELATIVE_TO_FILE && !startsWithSlash) {
                    ReferenceSupport.appendFileLocation(dirs, psiFile);
                }
                if (lookupOptions.RELATIVE_TO_SOURCE_ROOTS_START_WITH_SLASH && startsWithSlash || lookupOptions.RELATIVE_TO_SOURCE_ROOTS_START_WITHOUT_SLASH && !startsWithSlash) {
                    ReferenceSupport.appendSourceRoots((Collection<VirtualFile>)dirs, psiFile);
                }
                if (lookupOptions.ABSOLUTE) {
                    ReferenceSupport.appendFileSystemRoots(dirs);
                }
                if (lookupOptions.RELATIVE_TO_PROJECT_BASE_DIR) {
                    dirs.add(psiFile.getProject().getBaseDir());
                }
                if (lookupOptions.IN_ROOTS_OF_MODULE_DEPENDENCIES) {
                    ReferenceSupport.appendRootsOfModuleDependencies(dirs, ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile));
                }
                Collection collection = this.toFileSystemItems(dirs);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/ReferenceSupport$1", "computeDefaultContexts"));
                }
                return collection;
            }
        };
        return base.getAllReferences();
    }

    private static RelativeToWhat relativeToWhat(String path, PsiElement psiElement, LookupOptions lookupOptions) {
        Module module;
        if (lookupOptions.ABSOLUTE && (ALLOW_ABSOLUTE_REFERENCES_IN_TESTS || !ApplicationManager.getApplication().isUnitTestMode()) && (SystemInfo.isWindows ? path.length() > 2 && path.charAt(1) == ':' && Character.isLetter(path.charAt(0)) : path.startsWith("/") && LocalFileSystem.getInstance().findFileByPath(path) != null)) {
            return RelativeToWhat.Absolute;
        }
        if (lookupOptions.RELATIVE_TO_FILE) {
            VirtualFile vFile;
            PsiFile psiFile = psiElement.getContainingFile();
            PsiElement context = psiFile.getContext();
            if (context != null) {
                psiFile = context.getContainingFile();
            }
            if ((vFile = psiFile.getVirtualFile()) != null && VfsUtilCore.findRelativeFile((String)path, (VirtualFile)vFile) != null) {
                return RelativeToWhat.CurrentFile;
            }
        }
        if (lookupOptions.RELATIVE_TO_PROJECT_BASE_DIR && VfsUtilCore.findRelativeFile((String)path, (VirtualFile)psiElement.getProject().getBaseDir()) != null) {
            return RelativeToWhat.ProjectRoot;
        }
        if ((lookupOptions.RELATIVE_TO_SOURCE_ROOTS_START_WITH_SLASH && path.startsWith("/") || lookupOptions.RELATIVE_TO_SOURCE_ROOTS_START_WITHOUT_SLASH && !path.startsWith("/")) && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement)) != null) {
            for (VirtualFile sourceRoot : ModuleRootManager.getInstance((Module)module).getSourceRoots()) {
                if (VfsUtilCore.findRelativeFile((String)path, (VirtualFile)sourceRoot) == null) continue;
                return RelativeToWhat.SourceRoot;
            }
        }
        return lookupOptions.RELATIVE_TO_FILE ? RelativeToWhat.CurrentFile : RelativeToWhat.Other;
    }

    private static void appendFileLocation(List<VirtualFile> dirs, PsiFile psiFile) {
        VirtualFile file = psiFile.getVirtualFile();
        if (file != null) {
            dirs.add(file.getParent());
        }
    }

    private static void appendSourceRoots(Collection<VirtualFile> dirs, PsiFile psiFile) {
        VirtualFile file = psiFile.getVirtualFile();
        if (file != null && ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex().getSourceRootForFile(file) != null) {
            ReferenceSupport.appendSourceRoots(dirs, ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile));
        }
    }

    private static void appendSourceRoots(Collection<VirtualFile> dirs, Module module) {
        if (module != null) {
            ContainerUtil.addAll(dirs, (Object[])ModuleRootManager.getInstance((Module)module).getSourceRoots());
        }
    }

    private static void appendFileSystemRoots(Collection<VirtualFile> dirs) {
        ContainerUtil.addAll(dirs, (Object[])ManagingFS.getInstance().getLocalRoots());
    }

    private static void appendRootsOfModuleDependencies(List<VirtualFile> dirs, Module module) {
        if (module != null) {
            OrderEntry[] orderEntries;
            for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                if (orderEntry instanceof LibraryOrderEntry || orderEntry instanceof JdkOrderEntry) {
                    VirtualFile[] files;
                    for (VirtualFile file : files = orderEntry.getFiles(OrderRootType.CLASSES)) {
                        if (!"swc".equalsIgnoreCase(file.getExtension())) continue;
                        dirs.add(file);
                    }
                    continue;
                }
                if (!(orderEntry instanceof ModuleOrderEntry)) continue;
                ReferenceSupport.appendSourceRoots(dirs, ((ModuleOrderEntry)orderEntry).getModule());
            }
        }
    }

    public static class LookupOptions {
        public static final LookupOptions SCRIPT_SOURCE = new LookupOptions(false, true, true, false, false, false, false);
        public static final LookupOptions STYLE_SOURCE = new LookupOptions(false, true, true, true, true, false, true);
        public static final LookupOptions XML_AND_MODEL_SOURCE = new LookupOptions(false, true, true, true, false, false, false);
        public static final LookupOptions EMBEDDED_ASSET = new LookupOptions(true, true, true, true, false, false, true);
        public static final LookupOptions NON_EMBEDDED_ASSET = new LookupOptions(false, true, false, false, true, false, false);
        public static final LookupOptions FLEX_COMPILER_CONFIG_PATH_ELEMENT = new LookupOptions(false, true, true, false, false, true, false);
        public final boolean IGNORE_TEXT_AFTER_HASH;
        public final boolean ABSOLUTE;
        public final boolean RELATIVE_TO_FILE;
        public final boolean RELATIVE_TO_SOURCE_ROOTS_START_WITH_SLASH;
        public final boolean RELATIVE_TO_SOURCE_ROOTS_START_WITHOUT_SLASH;
        public final boolean RELATIVE_TO_PROJECT_BASE_DIR;
        public final boolean IN_ROOTS_OF_MODULE_DEPENDENCIES;

        public LookupOptions(boolean ignoreTextAfterHash, boolean absolute, boolean relativeToFile, boolean relativeToSourceRootsStartWithSlash, boolean relativeToSourceRootsStartWithoutSlash, boolean relativeToProjectBaseDir, boolean inRootsOfModuleDependencies) {
            this.IGNORE_TEXT_AFTER_HASH = ignoreTextAfterHash;
            this.ABSOLUTE = absolute;
            this.RELATIVE_TO_FILE = relativeToFile;
            this.RELATIVE_TO_SOURCE_ROOTS_START_WITH_SLASH = relativeToSourceRootsStartWithSlash;
            this.RELATIVE_TO_SOURCE_ROOTS_START_WITHOUT_SLASH = relativeToSourceRootsStartWithoutSlash;
            this.RELATIVE_TO_PROJECT_BASE_DIR = relativeToProjectBaseDir;
            this.IN_ROOTS_OF_MODULE_DEPENDENCIES = inRootsOfModuleDependencies;
        }
    }

    static enum RelativeToWhat {
        Absolute,
        CurrentFile,
        ProjectRoot,
        SourceRoot,
        Other;

    }
}

