/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.flex.JSFlexFileReference;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FlexFileReferenceHelper
extends FileReferenceHelper {
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/FlexFileReferenceHelper", "getContexts"));
        }
        List<PsiFileSystemItem> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/FlexFileReferenceHelper", "getContexts"));
        }
        return list;
    }

    public boolean isMine(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/FlexFileReferenceHelper", "isMine"));
        }
        return false;
    }

    @NotNull
    public List<? extends LocalQuickFix> registerFixes(FileReference reference) {
        PsiElement element = reference.getElement();
        if (!(reference instanceof JSFlexFileReference) || !(element instanceof JSAttributeNameValuePair)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/FlexFileReferenceHelper", "registerFixes"));
            }
            return list;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof JSAttribute) || !"Embed".equals(((JSAttribute)parent).getName())) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/FlexFileReferenceHelper", "registerFixes"));
            }
            return list;
        }
        String value = ((JSAttributeNameValuePair)element).getSimpleValue();
        if (value.startsWith("/")) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/FlexFileReferenceHelper", "registerFixes"));
            }
            return list;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/FlexFileReferenceHelper", "registerFixes"));
            }
            return list;
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
        boolean testSourceRoot = virtualFile != null && rootManager.getFileIndex().isInTestSourceContent(virtualFile);
        for (VirtualFile sourceRoot : rootManager.getSourceRoots(testSourceRoot)) {
            if (sourceRoot.findFileByRelativePath(value) == null) continue;
            List<AddLeadingSlashFix> list = Collections.singletonList(new AddLeadingSlashFix((JSAttributeNameValuePair)element));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/FlexFileReferenceHelper", "registerFixes"));
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/FlexFileReferenceHelper", "registerFixes"));
        }
        return list;
    }

    private static class AddLeadingSlashFix
    extends FixAndIntentionAction {
        private AddLeadingSlashFix(JSAttributeNameValuePair element) {
            this.registerElementRefForFix((PsiElement)element, null);
        }

        @NotNull
        public String getName() {
            if ("Add leading slash" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/FlexFileReferenceHelper$AddLeadingSlashFix", "getName"));
            }
            return "Add leading slash";
        }

        public boolean startInWriteAction() {
            return true;
        }

        protected void applyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor) {
            char quoteChar;
            ASTNode oldValueNode = ((JSAttributeNameValuePair)psiElement).getValueNode();
            String oldText = oldValueNode.getText();
            char c = quoteChar = oldText.length() > 0 ? (char)oldText.charAt(0) : (char)'\"';
            if (quoteChar != '\'' && quoteChar != '\"') {
                quoteChar = '\"';
            }
            String newText = quoteChar + "/" + StringUtil.stripQuotesAroundValue((String)oldText) + quoteChar;
            ASTNode newNode = JSChangeUtil.createExpressionFromText((Project)project, (String)newText);
            psiElement.getNode().replaceChild(oldValueNode, newNode.getFirstChildNode());
        }
    }
}

