/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.refactoring.JavascriptRefactoringSupportProvider;
import com.intellij.lang.javascript.refactoring.extractSuper.JSExtractInterfaceHandler;
import com.intellij.lang.javascript.refactoring.extractSuper.JSExtractSuperClassHandler;
import com.intellij.lang.javascript.refactoring.introduceConstant.JSIntroduceConstantHandler;
import com.intellij.lang.javascript.refactoring.introduceField.JSIntroduceFieldHandler;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpHandler;
import com.intellij.lang.javascript.refactoring.memberPushDown.JSPushDownHandler;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import org.jetbrains.annotations.NotNull;

public class ActionScriptRefactoringSupportProvider
extends JavascriptRefactoringSupportProvider {
    public boolean isAvailable(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/flex/ActionScriptRefactoringSupportProvider", "isAvailable"));
        }
        PsiFile containingFile = context.getContainingFile();
        return containingFile != null && containingFile.getLanguage().is((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4);
    }

    public RefactoringActionHandler getExtractInterfaceHandler() {
        return new JSExtractInterfaceHandler();
    }

    public RefactoringActionHandler getExtractSuperClassHandler() {
        return new JSExtractSuperClassHandler();
    }

    public RefactoringActionHandler getPullUpHandler() {
        return new JSPullUpHandler();
    }

    public RefactoringActionHandler getPushDownHandler() {
        return new JSPushDownHandler();
    }

    public RefactoringActionHandler getIntroduceConstantHandler() {
        return new JSIntroduceConstantHandler();
    }

    public RefactoringActionHandler getIntroduceFieldHandler() {
        return new JSIntroduceFieldHandler();
    }
}

