/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.arrangement;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.arrangement.ActionScriptArrangementEntry;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.SortedList;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptRearranger
implements Rearranger<ActionScriptArrangementEntry>,
ArrangementStandardSettingsAware {
    private static final Logger LOG = Logger.getInstance((String)ActionScriptRearranger.class.getName());
    private static final Set<ArrangementSettingsToken> SUPPORTED_TYPES = ContainerUtilRt.newLinkedHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.CONSTRUCTOR, StdArrangementTokens.EntryType.METHOD, StdArrangementTokens.EntryType.STATIC_INIT, StdArrangementTokens.EntryType.CONST, StdArrangementTokens.EntryType.VAR, StdArrangementTokens.EntryType.PROPERTY, StdArrangementTokens.EntryType.EVENT_HANDLER});
    private static final Set<ArrangementSettingsToken> SUPPORTED_MODIFIERS = ContainerUtilRt.newLinkedHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.PUBLIC, StdArrangementTokens.Modifier.PROTECTED, StdArrangementTokens.Modifier.PACKAGE_PRIVATE, StdArrangementTokens.Modifier.PRIVATE, StdArrangementTokens.Modifier.STATIC, StdArrangementTokens.Modifier.FINAL, StdArrangementTokens.Modifier.OVERRIDE});
    private static final StdArrangementSettings DEFAULT_SETTINGS;
    private static final DefaultArrangementSettingsSerializer SETTINGS_SERIALIZER;

    private static void addRule(List<StdArrangementMatchRule> rules, ArrangementSettingsToken ... conditions) {
        if (conditions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conditions", "com/intellij/lang/javascript/arrangement/ActionScriptRearranger", "addRule"));
        }
        if (conditions.length == 1) {
            rules.add(new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)new ArrangementAtomMatchCondition(conditions[0]))));
            return;
        }
        ArrangementCompositeMatchCondition composite = new ArrangementCompositeMatchCondition();
        for (ArrangementSettingsToken condition : conditions) {
            composite.addOperand((ArrangementMatchCondition)new ArrangementAtomMatchCondition(condition));
        }
        rules.add(new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)composite)));
    }

    @Nullable
    public Pair<ActionScriptArrangementEntry, List<ActionScriptArrangementEntry>> parseWithNew(@NotNull PsiElement root, @Nullable Document document, @NotNull Collection<TextRange> ranges, @NotNull PsiElement element, @NotNull ArrangementSettings settings) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/lang/javascript/arrangement/ActionScriptRearranger", "parseWithNew"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/lang/javascript/arrangement/ActionScriptRearranger", "parseWithNew"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/arrangement/ActionScriptRearranger", "parseWithNew"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/arrangement/ActionScriptRearranger", "parseWithNew"));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ActionScriptArrangementEntry> parse(@NotNull PsiElement root, @Nullable Document document, @NotNull Collection<TextRange> ranges, @NotNull ArrangementSettings settings) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/lang/javascript/arrangement/ActionScriptRearranger", "parse"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/lang/javascript/arrangement/ActionScriptRearranger", "parse"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/arrangement/ActionScriptRearranger", "parse"));
        }
        PsiFile file = root.getContainingFile();
        if (!(file instanceof JSFile)) {
            List<ActionScriptArrangementEntry> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/ActionScriptRearranger", "parse"));
            }
            return list;
        }
        JSClass jsClass = JSPsiImplUtils.findClass((JSFile)((JSFile)file));
        if (jsClass == null) {
            List<ActionScriptArrangementEntry> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/ActionScriptRearranger", "parse"));
            }
            return list;
        }
        SortedList result = new SortedList(ActionScriptArrangementEntry.COMPARATOR);
        JSBlockStatement[] blockStatements = (JSBlockStatement[])PsiTreeUtil.getChildrenOfType((PsiElement)jsClass, JSBlockStatement.class);
        if (blockStatements != null) {
            for (JSBlockStatement blockStatement : blockStatements) {
                ContainerUtil.addIfNotNull((Collection)result, (Object)((Object)ActionScriptArrangementEntry.create(blockStatement, ranges, document)));
            }
        }
        THashMap varToEntry = new THashMap();
        JSVarStatement[] varStatements = (JSVarStatement[])PsiTreeUtil.getChildrenOfType((PsiElement)jsClass, JSVarStatement.class);
        if (varStatements != null) {
            void var13_19;
            JSVarStatement[] jSVarStatementArray = varStatements;
            int blockStatement = jSVarStatementArray.length;
            boolean bl = false;
            while (var13_19 < blockStatement) {
                JSVarStatement varStatement = jSVarStatementArray[var13_19];
                ActionScriptArrangementEntry entry = ActionScriptArrangementEntry.create(varStatement, ranges, document);
                if (entry != null) {
                    result.add(entry);
                    JSVariable[] variables = varStatement.getVariables();
                    if (entry.getType() == StdArrangementTokens.EntryType.VAR && variables.length == 1) {
                        varToEntry.put(variables[0], entry);
                    }
                }
                ++var13_19;
            }
        }
        THashMap functionToEntry = new THashMap();
        for (JSFunction function : jsClass.getFunctions()) {
            ActionScriptArrangementEntry entry = ActionScriptArrangementEntry.create(function, ranges, document);
            if (entry == null) continue;
            result.add(entry);
            functionToEntry.put(function, entry);
        }
        for (Map.Entry entry : functionToEntry.entrySet()) {
            JSFunction function = (JSFunction)entry.getKey();
            String name = function.getName();
            if (!function.isSetProperty() || name == null) continue;
            ActionScriptArrangementEntry setterEntry = (ActionScriptArrangementEntry)((Object)entry.getValue());
            JSFunction getter = jsClass.findFunctionByNameAndKind(name, JSFunction.FunctionKind.GETTER);
            ActionScriptArrangementEntry getterEntry = (ActionScriptArrangementEntry)((Object)functionToEntry.get(getter));
            if (getterEntry == null) continue;
            setterEntry.addDependency((ArrangementEntry)getterEntry);
        }
        if (ActionScriptRearranger.groupPropertyFieldWithGetterSetter(settings)) {
            JSCodeStyleSettings codeStyleSettings = (JSCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)jsClass.getProject()).getCustomSettings(JSCodeStyleSettings.class);
            for (Map.Entry mapEntry : varToEntry.entrySet()) {
                ActionScriptArrangementEntry propertyEntry;
                JSVariable jsVar = (JSVariable)mapEntry.getKey();
                ActionScriptArrangementEntry varEntry = (ActionScriptArrangementEntry)((Object)mapEntry.getValue());
                if (!StringUtil.startsWith((CharSequence)jsVar.getName(), (CharSequence)codeStyleSettings.FIELD_PREFIX)) continue;
                String propertyName = JSRefactoringUtil.transformVarNameToAccessorName((String)jsVar.getName(), (Project)jsClass.getProject());
                JSFunction getterOrSetter = jsClass.findFunctionByNameAndKind(propertyName, JSFunction.FunctionKind.GETTER);
                if (getterOrSetter == null) {
                    getterOrSetter = jsClass.findFunctionByNameAndKind(propertyName, JSFunction.FunctionKind.SETTER);
                }
                if ((propertyEntry = getterOrSetter == null ? null : (ActionScriptArrangementEntry)((Object)functionToEntry.get(getterOrSetter))) == null) continue;
                varEntry.setType(propertyEntry.getType());
                varEntry.setModifiers(propertyEntry.getModifiers());
                propertyEntry.addDependency((ArrangementEntry)varEntry);
            }
        }
        SortedList sortedList = result;
        if (sortedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/ActionScriptRearranger", "parse"));
        }
        return sortedList;
    }

    private static boolean groupPropertyFieldWithGetterSetter(@NotNull ArrangementSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/arrangement/ActionScriptRearranger", "groupPropertyFieldWithGetterSetter"));
        }
        for (ArrangementGroupingRule rule : settings.getGroupings()) {
            if (rule.getGroupingType() != StdArrangementTokens.Grouping.GROUP_PROPERTY_FIELD_WITH_GETTER_SETTER) continue;
            return true;
        }
        return false;
    }

    public int getBlankLines(@NotNull CodeStyleSettings settings, @Nullable ActionScriptArrangementEntry parent, @Nullable ActionScriptArrangementEntry previous, @NotNull ActionScriptArrangementEntry target) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/arrangement/ActionScriptRearranger", "getBlankLines"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/lang/javascript/arrangement/ActionScriptRearranger", "getBlankLines"));
        }
        if (previous == null) {
            return -1;
        }
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4);
        ArrangementSettingsToken type = target.getType();
        if (StdArrangementTokens.EntryType.VAR.equals((Object)type) || StdArrangementTokens.EntryType.CONST.equals((Object)type)) {
            return commonSettings.BLANK_LINES_AROUND_FIELD;
        }
        if (StdArrangementTokens.EntryType.STATIC_INIT.equals((Object)type) || StdArrangementTokens.EntryType.CONSTRUCTOR.equals((Object)type) || StdArrangementTokens.EntryType.METHOD.equals((Object)type) || StdArrangementTokens.EntryType.PROPERTY.equals((Object)type) || StdArrangementTokens.EntryType.EVENT_HANDLER.equals((Object)type)) {
            return commonSettings.BLANK_LINES_AROUND_METHOD;
        }
        LOG.error((Object)target.getType());
        return 0;
    }

    @NotNull
    public ArrangementSettingsSerializer getSerializer() {
        DefaultArrangementSettingsSerializer defaultArrangementSettingsSerializer = SETTINGS_SERIALIZER;
        if (defaultArrangementSettingsSerializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/ActionScriptRearranger", "getSerializer"));
        }
        return defaultArrangementSettingsSerializer;
    }

    @Nullable
    public StdArrangementSettings getDefaultSettings() {
        return DEFAULT_SETTINGS;
    }

    public static List<StdArrangementMatchRule> getDefaultMatchRules() {
        ArrayList<StdArrangementMatchRule> matchRules = new ArrayList<StdArrangementMatchRule>();
        ArrangementSettingsToken[] visibility = new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.PUBLIC, StdArrangementTokens.Modifier.PROTECTED, StdArrangementTokens.Modifier.PACKAGE_PRIVATE, StdArrangementTokens.Modifier.PRIVATE};
        ActionScriptRearranger.addRule(matchRules, StdArrangementTokens.EntryType.STATIC_INIT);
        ActionScriptRearranger.addRule(matchRules, StdArrangementTokens.EntryType.CONST);
        for (ArrangementSettingsToken modifier : visibility) {
            ActionScriptRearranger.addRule(matchRules, StdArrangementTokens.EntryType.VAR, modifier, StdArrangementTokens.Modifier.STATIC);
        }
        for (ArrangementSettingsToken modifier : visibility) {
            ActionScriptRearranger.addRule(matchRules, StdArrangementTokens.EntryType.PROPERTY, modifier, StdArrangementTokens.Modifier.STATIC);
        }
        for (ArrangementSettingsToken modifier : visibility) {
            ActionScriptRearranger.addRule(matchRules, StdArrangementTokens.EntryType.METHOD, modifier, StdArrangementTokens.Modifier.STATIC);
        }
        ActionScriptRearranger.addRule(matchRules, StdArrangementTokens.EntryType.CONSTRUCTOR);
        for (ArrangementSettingsToken modifier : visibility) {
            ActionScriptRearranger.addRule(matchRules, StdArrangementTokens.EntryType.VAR, modifier);
        }
        ActionScriptRearranger.addRule(matchRules, StdArrangementTokens.EntryType.PROPERTY, StdArrangementTokens.Modifier.OVERRIDE);
        for (ArrangementSettingsToken modifier : visibility) {
            ActionScriptRearranger.addRule(matchRules, StdArrangementTokens.EntryType.PROPERTY, modifier);
        }
        ActionScriptRearranger.addRule(matchRules, StdArrangementTokens.EntryType.METHOD, StdArrangementTokens.Modifier.OVERRIDE);
        for (ArrangementSettingsToken modifier : visibility) {
            ActionScriptRearranger.addRule(matchRules, StdArrangementTokens.EntryType.METHOD, modifier);
        }
        ActionScriptRearranger.addRule(matchRules, StdArrangementTokens.EntryType.EVENT_HANDLER, StdArrangementTokens.Modifier.OVERRIDE);
        for (ArrangementSettingsToken modifier : visibility) {
            ActionScriptRearranger.addRule(matchRules, StdArrangementTokens.EntryType.EVENT_HANDLER, modifier);
        }
        return matchRules;
    }

    public boolean isEnabled(@NotNull ArrangementSettingsToken token, @Nullable ArrangementMatchCondition current) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/lang/javascript/arrangement/ActionScriptRearranger", "isEnabled"));
        }
        if (SUPPORTED_TYPES.contains(token) || StdArrangementTokens.Order.KEEP.equals((Object)token) || StdArrangementTokens.Order.BY_NAME.equals((Object)token) || StdArrangementTokens.Regexp.NAME.equals((Object)token)) {
            return true;
        }
        if (current == null) {
            return SUPPORTED_MODIFIERS.contains(token);
        }
        ArrangementSettingsToken type = ArrangementUtil.parseType((ArrangementMatchCondition)current);
        if (type == null) {
            return true;
        }
        if (StdArrangementTokens.EntryType.STATIC_INIT.equals((Object)type)) {
            return false;
        }
        if (StdArrangementTokens.EntryType.CONST.equals((Object)type)) {
            return StdArrangementTokens.Modifier.PUBLIC.equals((Object)token) || StdArrangementTokens.Modifier.PROTECTED.equals((Object)token) || StdArrangementTokens.Modifier.PACKAGE_PRIVATE.equals((Object)token) || StdArrangementTokens.Modifier.PRIVATE.equals((Object)token);
        }
        if (StdArrangementTokens.EntryType.VAR.equals((Object)type)) {
            return StdArrangementTokens.Modifier.STATIC.equals((Object)token) || StdArrangementTokens.Modifier.PUBLIC.equals((Object)token) || StdArrangementTokens.Modifier.PROTECTED.equals((Object)token) || StdArrangementTokens.Modifier.PACKAGE_PRIVATE.equals((Object)token) || StdArrangementTokens.Modifier.PRIVATE.equals((Object)token);
        }
        if (StdArrangementTokens.EntryType.CONSTRUCTOR.equals((Object)type)) {
            return false;
        }
        if (StdArrangementTokens.EntryType.METHOD.equals((Object)type) || StdArrangementTokens.EntryType.PROPERTY.equals((Object)type) || StdArrangementTokens.EntryType.EVENT_HANDLER.equals((Object)type)) {
            Map tokens = ArrangementUtil.extractTokens((ArrangementMatchCondition)current);
            if (StdArrangementTokens.Modifier.OVERRIDE.equals((Object)token) && tokens.keySet().contains(StdArrangementTokens.Modifier.STATIC)) {
                return false;
            }
            if (StdArrangementTokens.Modifier.STATIC.equals((Object)token) && (tokens.keySet().contains(StdArrangementTokens.Modifier.OVERRIDE) || tokens.keySet().contains(StdArrangementTokens.Modifier.FINAL))) {
                return false;
            }
            return !StdArrangementTokens.Modifier.FINAL.equals((Object)token) || !tokens.keySet().contains(StdArrangementTokens.Modifier.STATIC);
        }
        LOG.error((Object)type);
        return true;
    }

    @NotNull
    public Collection<Set<ArrangementSettingsToken>> getMutexes() {
        ArrayList result = ContainerUtilRt.newArrayList();
        result.add(SUPPORTED_TYPES);
        result.add(ContainerUtilRt.newHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.PUBLIC, StdArrangementTokens.Modifier.PROTECTED, StdArrangementTokens.Modifier.PACKAGE_PRIVATE, StdArrangementTokens.Modifier.PRIVATE}));
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/ActionScriptRearranger", "getMutexes"));
        }
        return arrayList;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedGroupingTokens() {
        return Collections.singletonList(new CompositeArrangementSettingsToken(StdArrangementTokens.Grouping.GROUP_PROPERTY_FIELD_WITH_GETTER_SETTER));
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedMatchingTokens() {
        return ContainerUtilRt.newArrayList((Object[])new CompositeArrangementSettingsToken[]{new CompositeArrangementSettingsToken(StdArrangementTokens.General.TYPE, SUPPORTED_TYPES), new CompositeArrangementSettingsToken(StdArrangementTokens.General.MODIFIER, SUPPORTED_MODIFIERS), new CompositeArrangementSettingsToken((ArrangementSettingsToken)StdArrangementTokens.Regexp.NAME), new CompositeArrangementSettingsToken(StdArrangementTokens.General.ORDER, new ArrangementSettingsToken[]{StdArrangementTokens.Order.KEEP, StdArrangementTokens.Order.BY_NAME})});
    }

    @NotNull
    public ArrangementEntryMatcher buildMatcher(@NotNull ArrangementMatchCondition condition) throws IllegalArgumentException {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/lang/javascript/arrangement/ActionScriptRearranger", "buildMatcher"));
        }
        throw new IllegalArgumentException("Can't build a matcher for condition " + condition);
    }

    static {
        List<ArrangementGroupingRule> groupingRules = Collections.singletonList(new ArrangementGroupingRule(StdArrangementTokens.Grouping.GROUP_PROPERTY_FIELD_WITH_GETTER_SETTER));
        List<StdArrangementMatchRule> matchRules = ActionScriptRearranger.getDefaultMatchRules();
        DEFAULT_SETTINGS = StdArrangementSettings.createByMatchRules(groupingRules, matchRules);
        SETTINGS_SERIALIZER = new DefaultArrangementSettingsSerializer(DEFAULT_SETTINGS);
    }
}

