/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.resolve;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeHelper;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptTypeHelper
extends JSTypeHelper {
    private static Key<PsiElement> ourResolvedTypeKey = Key.create((String)"resolved.type");
    private static JSTypeHelper ourTypeHelper = new ActionScriptTypeHelper();

    protected ActionScriptTypeHelper() {
    }

    public static JSTypeHelper getInstance() {
        return ourTypeHelper;
    }

    public boolean isAssignableToNamedType(@NotNull JSTypeImpl lOpType, @NotNull JSType rOpType, @Nullable ProcessingContext processingContext) {
        JSClass jsClass;
        if (lOpType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lOpType", "com/intellij/javascript/flex/resolve/ActionScriptTypeHelper", "isAssignableToNamedType"));
        }
        if (rOpType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rOpType", "com/intellij/javascript/flex/resolve/ActionScriptTypeHelper", "isAssignableToNamedType"));
        }
        Map cachesMap = processingContext != null ? (Map)processingContext.get((Object)this) : null;
        PsiElement type = (PsiElement)ourResolvedTypeKey.get(cachesMap);
        JSClass clazz = null;
        if (type == null) {
            type = lOpType.resolveClass();
            ourResolvedTypeKey.set(cachesMap, (Object)(type != null ? type : PsiUtilCore.NULL_PSI_ELEMENT));
        } else if (type == PsiUtilCore.NULL_PSI_ELEMENT) {
            type = null;
        }
        if (type instanceof JSClass) {
            clazz = (JSClass)type;
        }
        if ((jsClass = rOpType.resolveClass()) == null && rOpType instanceof JSTypeImpl || rOpType instanceof JSSpecialNamedTypeImpl) {
            return this.areNamedTypesAssignable((JSNamedType)lOpType, (JSNamedType)rOpType, processingContext);
        }
        if (jsClass != null && clazz != null) {
            return JSInheritanceUtil.isParentClass((JSClass)jsClass, (JSClass)clazz, (boolean)false, (PsiElement)jsClass);
        }
        return clazz != null;
    }
}

