/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.resolve;

import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.javascript.JSConditionalCompilationDefinitionsProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.e4x.JSE4XNamespaceReference;
import com.intellij.lang.javascript.psi.ecmal4.JSConditionalCompileVariableReference;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class ActionScriptReferenceExpressionResolver
extends JSReferenceExpressionResolver
implements JSResolveUtil.Resolver<JSReferenceExpressionImpl> {
    public ActionScriptReferenceExpressionResolver(JSReferenceExpressionImpl expression, PsiFile file) {
        super(expression, file);
    }

    public ResolveResult[] doResolve() {
        ResolveResult[] results;
        SinkResolveProcessor<ResolveResultSink> localProcessor;
        if (this.myReferencedName == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        PsiElement currentParent = JSResolveUtil.getTopReferenceParent((PsiElement)this.myParent);
        if (JSResolveUtil.isSelfReference((PsiElement)currentParent, (PsiElement)this.myRef) && (!(currentParent instanceof JSPackageStatement) || this.myParent == currentParent)) {
            return new ResolveResult[]{new JSResolveResult(currentParent)};
        }
        if (ActionScriptReferenceExpressionResolver.isConditionalVariableReference(currentParent, this.myRef)) {
            if (ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myRef) == null) {
                return new ResolveResult[]{new JSResolveResult((PsiElement)this.myRef)};
            }
            return ActionScriptReferenceExpressionResolver.resolveConditionalCompilationVariable((JSReferenceExpression)this.myRef);
        }
        if (this.myRef.isAttributeReference()) {
            return this.dummyResult((JSReferenceExpression)this.myRef);
        }
        if ("*".equals(this.myReferencedName)) {
            if (currentParent instanceof JSImportStatement && this.myQualifier instanceof JSReferenceExpression) {
                return ((JSReferenceExpression)this.myQualifier).multiResolve(false);
            }
            if (this.myParent instanceof JSE4XNamespaceReference) {
                return this.dummyResult((JSReferenceExpression)this.myRef);
            }
        }
        if (this.myParent instanceof JSReferenceListMember && this.myParent.getParent().getNode().getElementType() == JSStubElementTypes.IMPLEMENTS_LIST && this.myRef.getQualifier() == null && this.myContainingFile instanceof JSFile && XmlBackedJSClassImpl.isImplementsAttribute((JSFile)((JSFile)this.myContainingFile))) {
            PsiElement byQName = ActionScriptClassResolver.findClassByQNameStatic(this.myRef.getText(), (PsiElement)this.myRef);
            if (byQName != null) {
                return new ResolveResult[]{new JSResolveResult(byQName)};
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        if (this.myLocalResolve) {
            final PsiElement topParent = JSResolveUtil.getTopReferenceParent((PsiElement)this.myParent);
            localProcessor = new SinkResolveProcessor<ResolveResultSink>(this.myReferencedName, (PsiElement)this.myRef, new ResolveResultSink((PsiElement)this.myRef, this.myReferencedName)){

                public boolean needPackages() {
                    if (ActionScriptReferenceExpressionResolver.this.myParent instanceof JSReferenceExpression && topParent instanceof JSImportStatement) {
                        return true;
                    }
                    return super.needPackages();
                }
            };
            localProcessor.setToProcessHierarchy(true);
            JSReferenceExpressionImpl.doProcessLocalDeclarations((PsiElement)this.myRef, (JSExpression)this.myQualifier, (ResolveProcessor)localProcessor, (boolean)true, (boolean)false, null);
            PsiElement jsElement = localProcessor.getResult();
            if (this.myQualifier instanceof JSThisExpression && localProcessor.processingEncounteredAnyTypeAccess() && jsElement != null) {
                localProcessor.getResults().clear();
                jsElement = null;
            }
            if (this.myQualifier == null) {
                JSReferenceExpression namespaceReference = JSReferenceExpressionImpl.getNamespaceReference((JSReferenceExpression)this.myRef);
                ResolveResult[] resolveResultsAsConditionalCompilationVariable = null;
                if (namespaceReference != null && (namespaceReference == this.myRef || namespaceReference.resolve() == namespaceReference)) {
                    if (jsElement == null && ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myRef) == null) {
                        return new ResolveResult[]{new JSResolveResult((PsiElement)this.myRef)};
                    }
                    resolveResultsAsConditionalCompilationVariable = ActionScriptReferenceExpressionResolver.resolveConditionalCompilationVariable((JSReferenceExpression)this.myRef);
                }
                if (resolveResultsAsConditionalCompilationVariable != null && resolveResultsAsConditionalCompilationVariable.length > 0 && (jsElement == null || resolveResultsAsConditionalCompilationVariable[0].isValidResult())) {
                    return resolveResultsAsConditionalCompilationVariable;
                }
            }
            if (jsElement != null || localProcessor.isEncounteredDynamicClasses() && this.myQualifier == null || !localProcessor.processingEncounteredAnyTypeAccess() && !localProcessor.isEncounteredDynamicClasses()) {
                return localProcessor.getResultsAsResolveResults();
            }
        } else {
            QualifiedItemProcessor processor = new QualifiedItemProcessor((ResultSink)new ResolveResultSink((PsiElement)this.myRef, this.myReferencedName), this.myContainingFile);
            processor.setTypeContext(JSResolveUtil.isExprInTypeContext((JSReferenceExpression)this.myRef));
            JSTypeEvaluator.evaluateTypes((JSExpression)this.myQualifier, (PsiFile)this.myContainingFile, (JSTypeProcessor)processor);
            if (processor.resolved == QualifiedItemProcessor.TypeResolveState.PrefixUnknown) {
                return this.dummyResult((JSReferenceExpression)this.myRef);
            }
            if (processor.resolved == QualifiedItemProcessor.TypeResolveState.Resolved || processor.resolved == QualifiedItemProcessor.TypeResolveState.Undefined || processor.getResult() != null) {
                return processor.getResultsAsResolveResults();
            }
            localProcessor = processor;
        }
        if ((results = this.resolveFromIndices((SinkResolveProcessor)localProcessor)).length == 0 && localProcessor.isEncounteredXmlLiteral()) {
            return this.dummyResult((JSReferenceExpression)this.myRef);
        }
        return results;
    }

    protected void prepareProcessor(WalkUpResolveProcessor processor, @NotNull SinkResolveProcessor<ResolveResultSink> localProcessor) {
        boolean allowOnlyCompleteMatches;
        if (localProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localProcessor", "com/intellij/javascript/flex/resolve/ActionScriptReferenceExpressionResolver", "prepareProcessor"));
        }
        boolean inDefinition = false;
        boolean bl = allowOnlyCompleteMatches = this.myLocalResolve && localProcessor.isEncounteredDynamicClasses();
        if (this.myParent instanceof JSDefinitionExpression) {
            inDefinition = true;
            allowOnlyCompleteMatches = !this.myLocalResolve || !localProcessor.processingEncounteredAnyTypeAccess();
        } else if (this.myQualifier instanceof JSThisExpression && localProcessor.processingEncounteredAnyTypeAccess()) {
            processor.allowPartialResults();
        }
        if (inDefinition || allowOnlyCompleteMatches) {
            processor.setAddOnlyCompleteMatches(allowOnlyCompleteMatches);
        }
        processor.setSkipDefinitions(inDefinition);
        processor.addLocalResults(localProcessor);
    }

    protected ResolveResult[] getResultsForDefinition() {
        return new ResolveResult[]{new JSResolveResult(this.myParent)};
    }

    private static boolean isConditionalVariableReference(PsiElement currentParent, JSReferenceExpressionImpl thisElement) {
        if (currentParent instanceof JSConditionalCompileVariableReference) {
            return JSReferenceExpressionImpl.getNamespaceReference((JSReferenceExpression)thisElement) != null;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ResolveResult[] resolveConditionalCompilationVariable(JSReferenceExpression jsReferenceExpression) {
        String constantName;
        String namespace;
        PsiElement sibling;
        PsiElement parent = jsReferenceExpression.getParent();
        if (parent instanceof JSE4XNamespaceReference) {
            JSReferenceExpression namespaceReference = ((JSE4XNamespaceReference)parent).getNamespaceReference();
            PsiElement parentParent = parent.getParent();
            sibling = parent.getNextSibling();
            while (sibling instanceof PsiWhiteSpace) {
                sibling = sibling.getNextSibling();
            }
            if (namespaceReference == null || !(parentParent instanceof JSReferenceExpression) || sibling == null || sibling.getNextSibling() != null || sibling.getNode() == null || sibling.getNode().getElementType() != JSTokenTypes.IDENTIFIER) return new ResolveResult[]{new JSResolveResult((PsiElement)jsReferenceExpression, false)};
            namespace = namespaceReference.getText();
            constantName = sibling.getText();
        } else {
            JSE4XNamespaceReference namespaceElement = (JSE4XNamespaceReference)PsiTreeUtil.getChildOfType((PsiElement)jsReferenceExpression, JSE4XNamespaceReference.class);
            JSReferenceExpression namespaceReference = namespaceElement == null ? null : namespaceElement.getNamespaceReference();
            PsiElement psiElement = sibling = namespaceElement == null ? null : namespaceElement.getNextSibling();
            while (sibling instanceof PsiWhiteSpace) {
                sibling = sibling.getNextSibling();
            }
            if (namespaceElement == null || sibling == null || sibling.getNextSibling() != null || sibling.getNode() == null || sibling.getNode().getElementType() != JSTokenTypes.IDENTIFIER) return new ResolveResult[]{new JSResolveResult((PsiElement)jsReferenceExpression, false)};
            namespace = namespaceReference.getText();
            constantName = sibling.getText();
        }
        for (JSConditionalCompilationDefinitionsProvider provider : (JSConditionalCompilationDefinitionsProvider[])JSConditionalCompilationDefinitionsProvider.EP_NAME.getExtensions()) {
            if (!provider.containsConstant(ModuleUtilCore.findModuleForPsiElement((PsiElement)jsReferenceExpression), namespace, constantName)) continue;
            return new ResolveResult[]{new JSResolveResult((PsiElement)jsReferenceExpression)};
        }
        return new ResolveResult[]{new JSResolveResult((PsiElement)jsReferenceExpression, false)};
    }
}

