/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.mxml.schema;

import com.intellij.javascript.flex.mxml.schema.ClassBackedElementDescriptor;
import com.intellij.javascript.flex.mxml.schema.FlexSchemaHandler;
import com.intellij.javascript.flex.mxml.schema.MxmlLanguageTagsUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.AnnotationBackedDescriptor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MxmlTagNameReference
extends TagNameReference {
    public MxmlTagNameReference(ASTNode nameElement, boolean startTagFlag) {
        super(nameElement, startTagFlag);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        SchemaPrefixReference schemaPrefixReference;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/mxml/schema/MxmlTagNameReference", "bindToElement"));
        }
        String newPackage = MxmlTagNameReference.getNewPackage(element);
        if (newPackage == null) {
            return super.bindToElement(element);
        }
        XmlTag tag = this.getTagElement();
        if (tag == null || !this.myStartTagFlag) {
            return tag;
        }
        String newNamespace = newPackage.isEmpty() ? "*" : newPackage + ".*";
        String newPrefix = tag.getPrefixByNamespace(newNamespace);
        if (newPrefix == null) {
            XmlFile xmlFile = (XmlFile)tag.getContainingFile();
            newPrefix = FlexSchemaHandler.getUniquePrefix(newNamespace, xmlFile);
            XmlTag rootTag = xmlFile.getRootTag();
            assert (rootTag != null);
            MxmlTagNameReference.insertNamespaceDeclaration(rootTag, newNamespace, newPrefix);
        }
        SchemaPrefix schemaPrefix = (schemaPrefixReference = MxmlTagNameReference.getSchemaPrefixReference(tag)) == null ? null : schemaPrefixReference.resolve();
        String oldPrefix = tag.getNamespacePrefix();
        String newLocalName = FileUtil.getNameWithoutExtension((String)((PsiFile)element).getName());
        tag.setName(StringUtil.isEmpty((String)newPrefix) ? newLocalName : newPrefix + ":" + newLocalName);
        MxmlTagNameReference.fixSubTagsPrefixes(tag, oldPrefix, newPrefix);
        MxmlTagNameReference.removeNamespaceDeclarationIfNotUsed(schemaPrefix);
        return tag;
    }

    private static void fixSubTagsPrefixes(XmlTag tag, String oldPrefix, String newPrefix) {
        XmlElementDescriptor descriptor = tag.getDescriptor();
        if (!(descriptor instanceof ClassBackedElementDescriptor)) {
            return;
        }
        for (XmlTag subTag : tag.getSubTags()) {
            if (!Comparing.strEqual((String)subTag.getNamespacePrefix(), (String)oldPrefix) || subTag.getDescriptor() != null) continue;
            String oldSubTagName = subTag.getName();
            subTag.setName(StringUtil.isEmpty((String)newPrefix) ? subTag.getLocalName() : newPrefix + ":" + subTag.getLocalName());
            XmlElementDescriptor subTagDescriptor = descriptor.getElementDescriptor(subTag, tag);
            if (subTagDescriptor instanceof AnnotationBackedDescriptor) continue;
            subTag.setName(oldSubTagName);
        }
    }

    private static void removeNamespaceDeclarationIfNotUsed(SchemaPrefix schemaPrefix) {
        if (schemaPrefix == null) {
            return;
        }
        Ref hasUsagesRef = new Ref((Object)false);
        ReferencesSearch.search((PsiElement)schemaPrefix, (SearchScope)GlobalSearchScope.fileScope((PsiFile)schemaPrefix.getContainingFile())).forEach(reference -> {
            TextRange range = schemaPrefix.getTextRange();
            if (range != null && reference.getElement().getTextRange().getStartOffset() + reference.getRangeInElement().getStartOffset() == range.getStartOffset() && reference.getRangeInElement().getLength() == range.getLength()) {
                return true;
            }
            hasUsagesRef.set((Object)true);
            return false;
        });
        if (!((Boolean)hasUsagesRef.get()).booleanValue()) {
            XmlAttribute attribute = schemaPrefix.getDeclaration();
            MxmlLanguageTagsUtil.RemoveNamespaceDeclarationIntention.removeXmlAttribute(attribute);
        }
    }

    @Nullable
    private static SchemaPrefixReference getSchemaPrefixReference(XmlTag tag) {
        for (PsiReference reference : tag.getReferences()) {
            if (!(reference instanceof SchemaPrefixReference)) continue;
            return (SchemaPrefixReference)reference;
        }
        return null;
    }

    @Nullable
    private static String getNewPackage(PsiElement element) {
        VirtualFile sourceRoot;
        VirtualFile virtualFile;
        if ((element instanceof JSFile || element instanceof XmlFile && JavaScriptSupportLoader.isMxmlOrFxgFile((PsiFile)((XmlFile)element))) && (virtualFile = ((PsiFile)element).getVirtualFile()) != null && (sourceRoot = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().getSourceRootForFile(virtualFile)) != null) {
            String relPath = FileUtil.getRelativePath((String)sourceRoot.getPath(), (String)virtualFile.getPath(), (char)'/');
            int lastSlashIndex = relPath.lastIndexOf("/");
            return relPath.substring(0, Math.max(0, lastSlashIndex)).replace("/", ".");
        }
        return null;
    }

    public static void insertNamespaceDeclaration(@NotNull XmlTag tag, @NotNull String namespace, @NotNull String prefix) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/javascript/flex/mxml/schema/MxmlTagNameReference", "insertNamespaceDeclaration"));
        }
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/javascript/flex/mxml/schema/MxmlTagNameReference", "insertNamespaceDeclaration"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/javascript/flex/mxml/schema/MxmlTagNameReference", "insertNamespaceDeclaration"));
        }
        XmlAttribute[] attributes = tag.getAttributes();
        XmlAttribute anchor = null;
        for (XmlAttribute attribute : attributes) {
            XmlAttributeDescriptor descriptor = attribute.getDescriptor();
            if (!attribute.isNamespaceDeclaration() && (descriptor == null || !descriptor.isRequired())) break;
            anchor = attribute;
        }
        String qname = "xmlns" + (prefix.length() > 0 ? ":" + prefix : "");
        XmlAttribute attribute = XmlElementFactory.getInstance((Project)tag.getProject()).createXmlAttribute(qname, namespace);
        if (anchor == null) {
            tag.add((PsiElement)attribute);
        } else {
            tag.addAfter((PsiElement)attribute, (PsiElement)anchor);
        }
        CodeStyleManager.getInstance((Project)tag.getProject()).reformat((PsiElement)tag);
    }
}

