/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.mxml.schema;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.javascript.flex.mxml.schema.ClassBackedElementDescriptor;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.CreateEventMetadataByMxmlAttributeFix;
import com.intellij.lang.javascript.validation.fixes.CreateFieldByMxmlAttributeFix;
import com.intellij.lang.javascript.validation.fixes.CreateSetterByMxmlAttributeFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlUndefinedElementFixProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexUndefinedElementFixProvider
extends XmlUndefinedElementFixProvider {
    @Nullable
    public IntentionAction[] createFixes(@NotNull XmlAttribute attribute) {
        VirtualFile virtualFile;
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/javascript/flex/mxml/schema/FlexUndefinedElementFixProvider", "createFixes"));
        }
        if (!JavaScriptSupportLoader.isFlexMxmFile((PsiFile)attribute.getContainingFile())) {
            return null;
        }
        String name = attribute.getName();
        if (!JSRefactoringUtil.isValidIdentifier((String)name, (Project)attribute.getProject())) {
            return IntentionAction.EMPTY_ARRAY;
        }
        XmlElementDescriptor descriptor = attribute.getParent().getDescriptor();
        PsiElement declaration = descriptor instanceof ClassBackedElementDescriptor ? descriptor.getDeclaration() : null;
        VirtualFile virtualFile2 = virtualFile = declaration == null ? null : declaration.getContainingFile().getVirtualFile();
        if (virtualFile == null || ProjectRootManager.getInstance((Project)declaration.getProject()).getFileIndex().getSourceRootForFile(virtualFile) == null) {
            return IntentionAction.EMPTY_ARRAY;
        }
        if (declaration instanceof JSClass || declaration instanceof XmlFile && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)((XmlFile)declaration))) {
            String attributeValue = attribute.getValue();
            CreateFieldByMxmlAttributeFix fix1 = new CreateFieldByMxmlAttributeFix(name, attributeValue);
            fix1.registerElementRefForFix((PsiElement)attribute, null);
            CreateSetterByMxmlAttributeFix fix2 = new CreateSetterByMxmlAttributeFix(name, attributeValue);
            fix2.registerElementRefForFix((PsiElement)attribute, null);
            CreateEventMetadataByMxmlAttributeFix fix3 = new CreateEventMetadataByMxmlAttributeFix(name);
            fix3.registerElementRefForFix((PsiElement)attribute, null);
            return new IntentionAction[]{fix1, fix2, fix3};
        }
        return IntentionAction.EMPTY_ARRAY;
    }
}

