/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.mxml;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JSLanguageInjector;
import com.intellij.lang.javascript.JSTargetedInjector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.AnnotationBackedDescriptor;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.MxmlLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.xml.XmlElementDescriptorWithCDataContent;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MxmlLanguageInjector
implements MultiHostInjector,
JSTargetedInjector {
    public static final String PRIVATE_TAG_NAME = "Private";
    private static final String FUNCTION_CALL_PREFIX = "(function (... _){}) (";
    private static final String FUNCTION_CALL_SUFFIX = ");";
    private static final Language regexpLanguage = Language.findLanguageByID((String)"RegExp");
    private static final Language cssLanguage = Language.findLanguageByID((String)"CSS");

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/javascript/flex/mxml/MxmlLanguageInjector", "getLanguagesToInject"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/javascript/flex/mxml/MxmlLanguageInjector", "getLanguagesToInject"));
        }
        if (!host.getContainingFile().getLanguage().isKindOf((Language)MxmlLanguage.INSTANCE)) {
            return;
        }
        if (host instanceof XmlAttributeValue) {
            PsiElement attribute = host.getParent();
            PsiElement tag = attribute.getParent();
            if (attribute instanceof XmlAttribute && tag instanceof XmlTag) {
                if (MxmlLanguageInjector.isFxPrivateTag((XmlTag)tag) || MxmlLanguageInjector.isInsideFxPrivateTag((XmlTag)tag)) {
                    return;
                }
                if (host.getTextLength() == 0) {
                    return;
                }
                String attrName = ((XmlAttribute)attribute).getName();
                if ("implements".equals(attrName)) {
                    TextRange range = new TextRange(1, host.getTextLength() - 1);
                    registrar.startInjecting((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4).addPlace("class Foo implements ", " {}", (PsiLanguageInjectionHost)host, range).doneInjecting();
                } else if ("source".equals(attrName) && "Binding".equals(((XmlTag)tag).getLocalName()) && JavaScriptSupportLoader.isLanguageNamespace((String)((XmlTag)tag).getNamespace()) && !host.textContains('{')) {
                    TextRange range = new TextRange(1, host.getTextLength() - 1);
                    registrar.startInjecting((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4).addPlace(FUNCTION_CALL_PREFIX, FUNCTION_CALL_SUFFIX, (PsiLanguageInjectionHost)host, range).doneInjecting();
                } else if (attrName.equals("expression") && "RegExpValidator".equals(((XmlTag)tag).getLocalName()) && regexpLanguage != null) {
                    String hostText = host.getText();
                    int startPos = hostText.indexOf(47);
                    int endPos = hostText.lastIndexOf(47);
                    if (startPos != -1) {
                        if (endPos > startPos) {
                            TextRange range = new TextRange(startPos + 1, endPos);
                            registrar.startInjecting(regexpLanguage).addPlace(null, null, (PsiLanguageInjectionHost)host, range).doneInjecting();
                        }
                    } else {
                        MxmlLanguageInjector.injectInMxmlFile(registrar, host, (PsiMetaData)((XmlAttribute)attribute).getDescriptor(), (XmlTag)tag);
                    }
                } else {
                    MxmlLanguageInjector.injectInMxmlFile(registrar, host, (PsiMetaData)((XmlAttribute)attribute).getDescriptor(), (XmlTag)tag);
                }
            }
        } else if (host instanceof XmlText) {
            PsiElement _tag = host.getParent();
            if (_tag instanceof XmlTag) {
                XmlTag tag = (XmlTag)_tag;
                if (MxmlLanguageInjector.isFxPrivateTag(tag) || MxmlLanguageInjector.isInsideFxPrivateTag(tag) || tag instanceof HtmlTag) {
                    return;
                }
                String localName = tag.getLocalName();
                if (("Script".equals(localName) || "Metadata".equals(localName)) && tag.getAttributeValue("source") == null) {
                    JSLanguageInjector.injectToXmlText((MultiHostRegistrar)registrar, (PsiElement)host, (Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4, null, null);
                } else if ("Style".equals(localName) && FlexUtils.isMxmlNs(tag.getNamespace()) && cssLanguage != null) {
                    JSLanguageInjector.injectToXmlText((MultiHostRegistrar)registrar, (PsiElement)host, (Language)cssLanguage, null, null);
                } else if (tag.getSubTags().length == 0) {
                    MxmlLanguageInjector.injectInMxmlFile(registrar, host, (PsiMetaData)tag.getDescriptor(), tag);
                }
            }
        } else if (host instanceof XmlComment) {
            String text = host.getText();
            String marker = "<!---";
            if (text.startsWith("<!---")) {
                int end;
                String marker2 = "-->";
                int n = end = text.endsWith("-->") ? host.getTextLength() - "-->".length() : host.getTextLength();
                if (end < "<!---".length()) {
                    return;
                }
                TextRange range = new TextRange("<!---".length(), end);
                registrar.startInjecting((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4).addPlace("/***", "*/", (PsiLanguageInjectionHost)host, range).doneInjecting();
            }
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(XmlText.class, XmlAttributeValue.class, XmlComment.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/MxmlLanguageInjector", "elementsToInjectIn"));
        }
        return list;
    }

    public static boolean isFxPrivateTag(XmlTag tag) {
        return tag != null && PRIVATE_TAG_NAME.equals(tag.getLocalName()) && "http://ns.adobe.com/mxml/2009".equals(tag.getNamespace());
    }

    public static boolean isInsideFxPrivateTag(XmlTag tag) {
        if (tag == null) {
            return false;
        }
        XmlTag parent = tag;
        while ((parent = parent.getParentTag()) != null) {
            if (!MxmlLanguageInjector.isFxPrivateTag(parent)) continue;
            return true;
        }
        return false;
    }

    private static void injectInMxmlFile(MultiHostRegistrar registrar, PsiElement host, PsiMetaData descriptor, XmlTag tag) {
        int offset;
        int n = offset = host instanceof XmlText ? 0 : 1;
        if (descriptor instanceof AnnotationBackedDescriptor && ((XmlElementDescriptorWithCDataContent)descriptor).requiresCdataBracesInContext(tag)) {
            int length = host.getTextLength();
            if (length < 2 * offset) {
                return;
            }
            String type = ((AnnotationBackedDescriptor)descriptor).getType();
            if (type == null) {
                type = "*";
            }
            String prefix = "(function (event:" + type + ") {";
            String suffix = "})(null);";
            if (host instanceof XmlText) {
                JSLanguageInjector.injectToXmlText((MultiHostRegistrar)registrar, (PsiElement)host, (Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4, (String)prefix, (String)suffix);
            } else {
                String text;
                if ("Function".equals(type) && host.textContains('{') && (text = StringUtil.stripQuotesAroundValue((String)host.getText())).startsWith("{") && text.endsWith("}")) {
                    prefix = FUNCTION_CALL_PREFIX;
                    suffix = FUNCTION_CALL_SUFFIX;
                    ++offset;
                }
                TextRange range = new TextRange(offset, length - offset);
                registrar.startInjecting((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4).addPlace(prefix, (host instanceof XmlAttributeValue ? "\n" : "") + suffix, (PsiLanguageInjectionHost)host, range).doneInjecting();
            }
        } else if (!(host instanceof XmlText) || !MxmlLanguageInjector.hasCDATA((XmlText)host)) {
            String trimmedText;
            String text = StringUtil.stripQuotesAroundValue((String)host.getText());
            int openedBraces = 0;
            int start = -1;
            boolean addedSomething = false;
            boolean quoted = false;
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (quoted) {
                    quoted = false;
                    continue;
                }
                if (ch == '\\') {
                    quoted = true;
                    continue;
                }
                if (ch == '{') {
                    if (openedBraces == 0) {
                        start = i + 1;
                    }
                    ++openedBraces;
                    continue;
                }
                if (ch != '}' || --openedBraces != 0 || start == -1) continue;
                registrar.startInjecting((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4).addPlace(FUNCTION_CALL_PREFIX, FUNCTION_CALL_SUFFIX, (PsiLanguageInjectionHost)host, new TextRange(offset + start, i + offset)).doneInjecting();
                addedSomething = true;
                start = -1;
            }
            if (!addedSomething && (start = (trimmedText = text.trim()).indexOf("@")) == 0 && trimmedText.length() > 1 && Character.isUpperCase(trimmedText.charAt(1))) {
                registrar.startInjecting((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4).addPlace(null, null, (PsiLanguageInjectionHost)host, new TextRange(offset += text.indexOf(trimmedText), trimmedText.length() + offset)).doneInjecting();
            }
        }
    }

    private static boolean hasCDATA(XmlText xmlText) {
        for (PsiElement element : xmlText.getChildren()) {
            ASTNode node = element.getNode();
            if (node == null || node.getElementType() != XmlElementType.XML_CDATA) continue;
            return true;
        }
        return false;
    }
}

