/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.maven;

import com.intellij.javascript.flex.maven.FlexConfigInformer;
import com.intellij.javascript.flex.maven.Flexmojos3Configurator;
import com.intellij.javascript.flex.maven.Flexmojos4GenerateConfigTask;
import com.intellij.javascript.flex.maven.RuntimeModulesGenerateConfigTask;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexProjectConfigurationEditor;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;

public class Flexmojos4Configurator
extends Flexmojos3Configurator {
    public Flexmojos4Configurator(Module module, IdeModifiableModelsProvider modifiableModelsProvider, FlexProjectConfigurationEditor flexEditor, MavenProjectsTree mavenTree, Map<MavenProject, String> mavenProjectToModuleName, MavenProject mavenProject, MavenPlugin flexmojosPlugin, List<String> compiledLocales, List<String> runtimeLocales, FlexConfigInformer informer) {
        super(module, modifiableModelsProvider, flexEditor, mavenTree, mavenProjectToModuleName, mavenProject, flexmojosPlugin, compiledLocales, runtimeLocales, informer);
    }

    public static String getCompilerConfigsDir(Project project) {
        return project.getBaseDir().getPath() + "/.idea/flexmojos";
    }

    @Override
    @Nullable
    protected String getCompilerConfigFilePath(String rlmName) {
        Element configurationElement = this.myFlexmojosPlugin.getConfigurationElement();
        String classifier = configurationElement == null ? null : configurationElement.getChildTextNormalize("classifier", configurationElement.getNamespace());
        String suffix = "";
        if (rlmName != null) {
            suffix = "-" + rlmName;
        } else if (classifier != null) {
            suffix = "-" + classifier;
        }
        return Flexmojos4Configurator.getCompilerConfigsDir(this.myModule.getProject()) + "/" + this.myMavenProject.getMavenId().getArtifactId() + "-" + this.myMavenProject.getMavenId().getGroupId() + suffix + ".xml";
    }

    @Override
    protected Collection<RuntimeModulesGenerateConfigTask.RLMInfo> getRLMInfos() {
        Element modulesElement;
        Element configurationElement = this.myFlexmojosPlugin.getConfigurationElement();
        Element element = modulesElement = configurationElement == null ? null : configurationElement.getChild("modules", configurationElement.getNamespace());
        if (modulesElement == null) {
            return Collections.emptyList();
        }
        ArrayList<RuntimeModulesGenerateConfigTask.RLMInfo> result = new ArrayList<RuntimeModulesGenerateConfigTask.RLMInfo>();
        for (Element moduleElement : modulesElement.getChildren()) {
            if (moduleElement.getChildren().size() > 0) {
                String mainClassRelativePath = moduleElement.getChildTextNormalize("sourceFile", moduleElement.getNamespace());
                String finalName = moduleElement.getChildTextNormalize("finalName", moduleElement.getNamespace());
                String destinationPath = moduleElement.getChildTextNormalize("destinationPath", moduleElement.getNamespace());
                String mainClass = FileUtil.getNameWithoutExtension((String)mainClassRelativePath.replace('/', '.'));
                String rlmName = StringUtil.notNullize((String)finalName, (String)StringUtil.getShortName((String)mainClass));
                String outputFileName = finalName != null ? finalName + ".swf" : this.myMavenProject.getFinalName() + "-" + rlmName.toLowerCase() + ".swf";
                String outputFolderPath = FileUtil.toSystemIndependentName((String)(this.myMavenProject.getBuildDirectory() + (destinationPath == null ? "" : "/" + destinationPath)));
                String configFilePath = this.getCompilerConfigFilePath(rlmName);
                result.add(new RuntimeModulesGenerateConfigTask.RLMInfo(rlmName, mainClass, mainClassRelativePath, outputFileName, outputFolderPath, configFilePath));
                continue;
            }
            String path = moduleElement.getTextNormalize();
            if (!path.endsWith(".mxml") && !path.endsWith(".as")) continue;
            String mainClassRelativePath = FileUtil.toSystemIndependentName((String)path);
            String mainClass = FileUtil.getNameWithoutExtension((String)mainClassRelativePath.replace('/', '.'));
            String rlmName = StringUtil.getShortName((String)mainClass);
            String outputFileName = this.myMavenProject.getFinalName() + "-" + rlmName.toLowerCase() + ".swf";
            String outputFolderPath = FileUtil.toSystemIndependentName((String)this.myMavenProject.getBuildDirectory());
            String configFilePath = this.getCompilerConfigFilePath(rlmName);
            result.add(new RuntimeModulesGenerateConfigTask.RLMInfo(rlmName, mainClass, mainClassRelativePath, outputFileName, outputFolderPath, configFilePath));
        }
        return result;
    }

    @Override
    protected void appendGenerateConfigTask(List<MavenProjectsProcessorTask> postTasks, String configFilePath) {
        Project project = this.myModule.getProject();
        Flexmojos4GenerateConfigTask existingTask = null;
        for (MavenProjectsProcessorTask postTask : postTasks) {
            if (postTask.getClass() != Flexmojos4GenerateConfigTask.class) continue;
            existingTask = (Flexmojos4GenerateConfigTask)postTask;
            break;
        }
        if (existingTask == null) {
            ChangeListManager.getInstance((Project)project).addFilesToIgnore(new IgnoredFileBean[]{IgnoredBeanFactory.ignoreUnderDirectory((String)Flexmojos4Configurator.getCompilerConfigsDir(project), (Project)project)});
            existingTask = new Flexmojos4GenerateConfigTask(this.myMavenTree);
            postTasks.add((MavenProjectsProcessorTask)existingTask);
        }
        existingTask.submit(this.myMavenProject, this.myModule, configFilePath);
    }
}

