/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.maven;

import com.intellij.flex.model.bc.OutputType;
import com.intellij.ide.IdeBundle;
import com.intellij.javascript.flex.maven.FlexConfigInformer;
import com.intellij.javascript.flex.maven.FlexmojosImporter;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableFlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexProjectConfigurationEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorBasicTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.MavenServerExecutionResult;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class Flexmojos3GenerateConfigTask
extends MavenProjectsProcessorBasicTask {
    private static final String TEMPORARY_FILE_CONTENT = "Remove this file";
    private final Module myModule;
    private final String myConfigFilePath;
    private final FlexConfigInformer myFlexConfigInformer;

    public Flexmojos3GenerateConfigTask(Module module, MavenProject mavenProject, MavenProjectsTree mavenTree, String configFilePath, FlexConfigInformer flexConfigInformer) {
        super(mavenProject, mavenTree);
        this.myModule = module;
        this.myConfigFilePath = configFilePath;
        this.myFlexConfigInformer = flexConfigInformer;
    }

    public void perform(final Project project, MavenEmbeddersManager embeddersManager, final MavenConsole console, final MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        if (this.myModule.isDisposed()) {
            return;
        }
        indicator.setText(FlexBundle.message("generating.flex.config.for", this.myMavenProject.getDisplayName()));
        MavenProjectsTree.EmbedderTask task = new MavenProjectsTree.EmbedderTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(MavenEmbedderWrapper embedder) throws MavenProcessCanceledException {
                List temporaryFiles = null;
                IgnoredFileBean[] filesToIgnoreOriginal = ChangeListManager.getInstance((Project)project).getFilesToIgnore();
                try {
                    MavenWorkspaceMap workspaceMap = new MavenWorkspaceMap();
                    temporaryFiles = Flexmojos3GenerateConfigTask.mavenIdToOutputFileMapping(workspaceMap, project, Flexmojos3GenerateConfigTask.this.myTree.getProjects());
                    embedder.customizeForStrictResolve(workspaceMap, console, indicator);
                    String generateConfigGoal = "org.sonatype.flexmojos:flexmojos-maven-plugin:generate-config-" + Flexmojos3GenerateConfigTask.this.myMavenProject.getPackaging();
                    MavenExplicitProfiles profilesIds = Flexmojos3GenerateConfigTask.this.myMavenProject.getActivatedProfilesIds();
                    MavenServerExecutionResult result = embedder.execute(Flexmojos3GenerateConfigTask.this.myMavenProject.getFile(), profilesIds.getEnabledProfiles(), profilesIds.getDisabledProfiles(), Collections.singletonList(generateConfigGoal));
                    if (result.projectData == null) {
                        Flexmojos3GenerateConfigTask.this.myFlexConfigInformer.showFlexConfigWarningIfNeeded(project);
                    }
                    MavenUtil.invokeAndWaitWriteAction((Project)project, () -> {
                        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(Flexmojos3GenerateConfigTask.this.myConfigFilePath);
                        if (file != null) {
                            file.refresh(false, false);
                            Flexmojos3GenerateConfigTask.updateMainClass(Flexmojos3GenerateConfigTask.this.myModule, file);
                        }
                    });
                }
                catch (MavenProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    Flexmojos3GenerateConfigTask.this.myFlexConfigInformer.showFlexConfigWarningIfNeeded(project);
                    console.printException((Throwable)e);
                    MavenLog.LOG.warn((Throwable)e);
                }
                finally {
                    ChangeListManager.getInstance((Project)project).setFilesToIgnore(filesToIgnoreOriginal);
                    if (temporaryFiles != null && !temporaryFiles.isEmpty()) {
                        Flexmojos3GenerateConfigTask.removeTemporaryFiles(project, temporaryFiles);
                    }
                }
            }
        };
        this.myTree.executeWithEmbedder(this.myMavenProject, embeddersManager, MavenEmbeddersManager.FOR_POST_PROCESSING, console, indicator, task);
    }

    private static List<VirtualFile> mavenIdToOutputFileMapping(MavenWorkspaceMap workspaceMap, Project project, Collection<MavenProject> mavenProjects) throws IOException {
        Ref exception = new Ref();
        ArrayList<VirtualFile> temporaryFiles = new ArrayList<VirtualFile>();
        MavenUtil.invokeAndWaitWriteAction((Project)project, () -> {
            try {
                for (MavenProject mavenProject : mavenProjects) {
                    if (ArrayUtil.contains((String)mavenProject.getPackaging(), (String[])FlexmojosImporter.SUPPORTED_PACKAGINGS)) {
                        String outputFilePath = FlexmojosImporter.getOutputFilePath(mavenProject);
                        int lastSlashIndex = outputFilePath.lastIndexOf("/");
                        String outputFileName = outputFilePath.substring(lastSlashIndex + 1);
                        String outputFolderPath = outputFilePath.substring(0, Math.max(0, lastSlashIndex));
                        VirtualFile outputFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(outputFilePath);
                        if (outputFile == null) {
                            VirtualFile outputDir = VfsUtil.createDirectoryIfMissing((String)outputFolderPath);
                            if (outputDir == null) {
                                throw new IOException(IdeBundle.message((String)"error.failed.to.create.directory", (Object[])new Object[]{outputFolderPath}));
                            }
                            ChangeListManager.getInstance((Project)project).addFilesToIgnore(new IgnoredFileBean[]{IgnoredBeanFactory.ignoreFile((String)outputFilePath, (Project)project)});
                            outputFile = FlexUtils.addFileWithContent(outputFileName, TEMPORARY_FILE_CONTENT, outputDir);
                            if (outputFile == null) {
                                throw new IOException(IdeBundle.message((String)"error.message.unable.to.create.file", (Object[])new Object[]{outputFileName}));
                            }
                            temporaryFiles.add(outputFile);
                        }
                        workspaceMap.register(mavenProject.getMavenId(), new File(mavenProject.getFile().getPath()), new File(outputFile.getPath()));
                        continue;
                    }
                    workspaceMap.register(mavenProject.getMavenId(), new File(mavenProject.getFile().getPath()));
                }
            }
            catch (IOException e) {
                exception.set((Object)e);
            }
        });
        if (!exception.isNull()) {
            throw (IOException)exception.get();
        }
        return temporaryFiles;
    }

    private static void removeTemporaryFiles(Project project, Collection<VirtualFile> files) {
        MavenUtil.invokeAndWaitWriteAction((Project)project, () -> {
            for (VirtualFile file : files) {
                try {
                    if (!file.isValid() || file.getLength() != (long)TEMPORARY_FILE_CONTENT.length() || !new String(file.contentsToByteArray()).equals(TEMPORARY_FILE_CONTENT)) continue;
                    file.delete(Flexmojos3GenerateConfigTask.class);
                }
                catch (IOException iOException) {}
            }
        });
    }

    public static void updateMainClass(Module module, VirtualFile configFile) {
        if (FlexBuildConfigurationsExtension.getInstance().getConfigurator().getConfigEditor() != null) {
            return;
        }
        try {
            VirtualFile mainClassFile;
            String mainClassPath = FlexUtils.findXMLElement(configFile.getInputStream(), "<flex-config><file-specs><path-element>");
            VirtualFile virtualFile = mainClassFile = mainClassPath == null ? null : LocalFileSystem.getInstance().findFileByPath(mainClassPath);
            if (mainClassFile == null || mainClassFile.isDirectory()) {
                return;
            }
            VirtualFile sourceRoot = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex().getSourceRootForFile(mainClassFile);
            String relativePath = sourceRoot == null ? null : VfsUtilCore.getRelativePath((VirtualFile)mainClassFile, (VirtualFile)sourceRoot, (char)'/');
            String mainClass = relativePath == null ? mainClassFile.getNameWithoutExtension() : FileUtil.getNameWithoutExtension((String)relativePath).replace('/', '.');
            ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            LibraryTable.ModifiableModel librariesModel = ProjectLibraryTable.getInstance((Project)module.getProject()).getModifiableModel();
            FlexProjectConfigurationEditor flexEditor = FlexProjectConfigurationEditor.createEditor(module.getProject(), Collections.singletonMap(module, modifiableModel), librariesModel, null);
            Object[] bcs = flexEditor.getConfigurations(module);
            ModifiableFlexBuildConfiguration mainBC = (ModifiableFlexBuildConfiguration)ContainerUtil.find((Object[])bcs, bc -> bc.getOutputType() == OutputType.Application && module.getName().equals(bc.getName()));
            if (mainBC != null) {
                mainBC.setMainClass(mainClass);
            }
            flexEditor.commit();
            Disposer.dispose((Disposable)librariesModel);
            modifiableModel.dispose();
        }
        catch (IOException iOException) {
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }
}

