/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.css;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.indexing.IndexableSetContributor;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FlexStylesIndexableSetContributor
extends IndexableSetContributor {
    private static final Logger LOG = Logger.getInstance(FlexStylesIndexableSetContributor.class);
    private static final NotNullLazyValue<Set<VirtualFile>> ourFiles = new AtomicNotNullLazyValue<Set<VirtualFile>>(){

        @NotNull
        protected Set<VirtualFile> compute() {
            URL libFileUrl = FlexStylesIndexableSetContributor.class.getResource("FlexStyles.as");
            VirtualFile file = VfsUtil.findFileByURL((URL)libFileUrl);
            if (file != null) {
                Set<VirtualFile> set = Collections.singleton(file);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexStylesIndexableSetContributor$1", "compute"));
                }
                return set;
            }
            LOG.error("Cannot find FlexStyles.as file by URL " + libFileUrl);
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexStylesIndexableSetContributor$1", "compute"));
            }
            return set;
        }
    };

    @NotNull
    public Set<VirtualFile> getAdditionalRootsToIndex() {
        Set set = (Set)ourFiles.getValue();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexStylesIndexableSetContributor", "getAdditionalRootsToIndex"));
        }
        return set;
    }

    @NotNull
    public static GlobalSearchScope enlarge(final @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/javascript/flex/css/FlexStylesIndexableSetContributor", "enlarge"));
        }
        GlobalSearchScope globalSearchScope = scope.union((SearchScope)new GlobalSearchScope(){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/flex/css/FlexStylesIndexableSetContributor$2", "contains"));
                }
                return ((Set)ourFiles.getValue()).contains(file);
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/javascript/flex/css/FlexStylesIndexableSetContributor$2", "compare"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/javascript/flex/css/FlexStylesIndexableSetContributor$2", "compare"));
                }
                return scope.compare(file1, file2);
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/javascript/flex/css/FlexStylesIndexableSetContributor$2", "isSearchInModuleContent"));
                }
                return scope.isSearchInModuleContent(aModule);
            }

            public boolean isSearchInLibraries() {
                return scope.isSearchInLibraries();
            }
        });
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexStylesIndexableSetContributor", "enlarge"));
        }
        return globalSearchScope;
    }
}

