/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.css;

import com.intellij.javascript.flex.FlexApplicationComponent;
import com.intellij.lang.javascript.ActionScriptFileType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import org.jetbrains.annotations.NotNull;

class FlexInputFilter
extends DefaultFileTypeSpecificInputFilter {
    private FlexInputFilter() {
        super(new FileType[]{ActionScriptFileType.INSTANCE, FlexApplicationComponent.SWF_FILE_TYPE, JavaScriptSupportLoader.getMxmlFileType()});
    }

    public static FlexInputFilter getInstance() {
        return FlexInputFilterHolder.ourInstance;
    }

    public boolean acceptInput(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/flex/css/FlexInputFilter", "acceptInput"));
        }
        FileType type = file.getFileType();
        if (type == ActionScriptFileType.INSTANCE || type == FlexApplicationComponent.SWF_FILE_TYPE && file.getFileSystem() instanceof JarFileSystem) {
            return true;
        }
        return JavaScriptSupportLoader.isFlexMxmFile((VirtualFile)file);
    }

    private static class FlexInputFilterHolder {
        private static final FlexInputFilter ourInstance = new FlexInputFilter();

        private FlexInputFilterHolder() {
        }
    }
}

