/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.css;

import com.intellij.javascript.flex.css.FlexCssUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.css.resolve.CssElementProcessor;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.impl.CssResolverImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiPolyVariantCachingReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssClassValueReference
extends PsiPolyVariantCachingReference
implements CssReference {
    private final PsiElement myElement;
    private final int myStart;
    private final int myEnd;

    public CssClassValueReference(@NotNull PsiElement element) {
        int length;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/css/CssClassValueReference", "<init>"));
        }
        this.myElement = element;
        String value = CssClassValueReference.getValue(this.myElement);
        int n = length = value != null ? value.length() : 0;
        if (length == 0) {
            this.myStart = 0;
            this.myEnd = 0;
        } else if (element instanceof CssString || FlexCssUtil.inQuotes(this.myElement.getText())) {
            String text = this.myElement.getText();
            this.myStart = text.length() >= 2 && text.charAt(1) == '.' ? 2 : 1;
            this.myEnd = length + 1;
        } else {
            this.myStart = 0;
            this.myEnd = length;
        }
    }

    public static String getValue(PsiElement element) {
        if (element instanceof CssString) {
            return ((CssString)element).getValue();
        }
        String text = element.getText();
        if (FlexCssUtil.inQuotes(text)) {
            return text.substring(text.length() >= 2 && text.charAt(1) == '.' ? 2 : 1, text.length() - 1);
        }
        return text;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = CssBundle.message((String)"invalid.css.class", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/CssClassValueReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return new TextRange(this.myStart, this.myEnd);
    }

    @NotNull
    public String getCanonicalText() {
        String value = CssClassValueReference.getValue(this.myElement);
        String string = value != null ? value : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/CssClassValueReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myElement);
        assert (manipulator != null);
        return manipulator.handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/css/CssClassValueReference", "bindToElement"));
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        MyCandidatesProcessor processor = new MyCandidatesProcessor();
        this.processStyles(processor);
        Object[] objectArray = processor.myStyleNames.toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/CssClassValueReference", "getVariants"));
        }
        return objectArray;
    }

    @NotNull
    protected ResolveResult[] resolveInner(boolean incompleteCode, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/javascript/flex/css/CssClassValueReference", "resolveInner"));
        }
        String value = CssClassValueReference.getValue(this.myElement);
        if (value == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/CssClassValueReference", "resolveInner"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        MyResolveProcessor processor = new MyResolveProcessor(value);
        this.processStyles(processor);
        if (processor.myTargets.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/CssClassValueReference", "resolveInner"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)processor.myTargets);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/CssClassValueReference", "resolveInner"));
        }
        return resolveResultArray;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (element instanceof CssSelectorSuffix) {
            String text = element.getText();
            return text != null && !text.isEmpty() && text.substring(1).equals(CssClassValueReference.getValue(this.myElement));
        }
        return false;
    }

    public boolean isSoft() {
        return true;
    }

    private void processStyles(CssElementProcessor processor) {
        PsiFile context;
        PsiFile file = this.myElement.getContainingFile();
        if (!(file instanceof XmlFile) && (context = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file)) instanceof XmlFile) {
            file = (XmlFile)context;
        }
        if (file instanceof XmlFile) {
            CssResolveManager.getInstance().getNewResolver().processOneFile((XmlFile)file, processor, true);
        } else if (file instanceof StylesheetFile) {
            CssClassValueReference.processOneStylesheetFile((StylesheetFile)file, processor);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module != null) {
            CssResolverImpl.processStyles((Module)module, (CssElementProcessor)processor, (PsiFile)file);
        }
    }

    private static void processOneStylesheetFile(@NotNull StylesheetFile file, @NotNull CssElementProcessor processor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/flex/css/CssClassValueReference", "processOneStylesheetFile"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/javascript/flex/css/CssClassValueReference", "processOneStylesheetFile"));
        }
        CssStylesheet stylesheet = file.getStylesheet();
        if (stylesheet != null) {
            for (CssRuleset ruleset : stylesheet.getRulesets()) {
                processor.process(ruleset);
            }
        }
    }

    private static abstract class MyCssElementProcessor
    extends CssElementProcessor {
        private MyCssElementProcessor() {
        }

        public boolean process(@NotNull CssRuleset ruleset) {
            if (ruleset == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ruleset", "com/intellij/javascript/flex/css/CssClassValueReference$MyCssElementProcessor", "process"));
            }
            for (CssSelector selector : ruleset.getSelectors()) {
                for (PsiElement child : selector.getChildren()) {
                    if (!(child instanceof CssSimpleSelector)) continue;
                    for (CssSelectorSuffix selectorSuffix : ((CssSimpleSelector)child).getSelectorSuffixes()) {
                        String text = selectorSuffix.getText();
                        if (text == null || text.isEmpty() || text.charAt(0) != '.') continue;
                        this.handleSelector(selectorSuffix, text.substring(1));
                        ProgressIndicatorProvider.checkCanceled();
                    }
                }
            }
            return true;
        }

        protected abstract void handleSelector(@NotNull CssSelectorSuffix var1, @NotNull String var2);
    }

    private static class MyResolveProcessor
    extends MyCssElementProcessor {
        private final String myReferenceText;
        private final Set<CssSelectorSuffix> myTargets;

        private MyResolveProcessor(@NotNull String referenceText) {
            if (referenceText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/intellij/javascript/flex/css/CssClassValueReference$MyResolveProcessor", "<init>"));
            }
            this.myTargets = ContainerUtil.newLinkedHashSet();
            this.myReferenceText = referenceText;
        }

        @Override
        protected void handleSelector(@NotNull CssSelectorSuffix selectorSuffix, @NotNull String text) {
            if (selectorSuffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorSuffix", "com/intellij/javascript/flex/css/CssClassValueReference$MyResolveProcessor", "handleSelector"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/javascript/flex/css/CssClassValueReference$MyResolveProcessor", "handleSelector"));
            }
            if (text.equals(this.myReferenceText)) {
                this.myTargets.add(selectorSuffix);
            }
        }
    }

    private static class MyCandidatesProcessor
    extends MyCssElementProcessor {
        Set<String> myStyleNames = ContainerUtil.newLinkedHashSet();

        private MyCandidatesProcessor() {
        }

        @Override
        protected void handleSelector(@NotNull CssSelectorSuffix selectorSuffix, @NotNull String text) {
            if (selectorSuffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorSuffix", "com/intellij/javascript/flex/css/CssClassValueReference$MyCandidatesProcessor", "handleSelector"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/javascript/flex/css/CssClassValueReference$MyCandidatesProcessor", "handleSelector"));
            }
            this.myStyleNames.add(text);
        }
    }
}

