/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.compiled;

import com.intellij.lang.javascript.flex.importer.FlexImporter;
import com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class SwfFileDecompiler
implements BinaryFileDecompiler {
    @NotNull
    public CharSequence decompile(VirtualFile file) {
        String string;
        Project project = SwfFileDecompiler.findProject();
        if (project == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/compiled/SwfFileDecompiler", "decompile"));
            }
            return "";
        }
        try {
            string = FlexImporter.buildInterfaceFromStream(file.getInputStream());
        }
        catch (IOException ex) {
            CharSequence charSequence = ArrayUtil.EMPTY_CHAR_SEQUENCE;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/compiled/SwfFileDecompiler", "decompile"));
            }
            return charSequence;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/compiled/SwfFileDecompiler", "decompile"));
        }
        return string;
    }

    private static Project findProject() {
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        if (projects.length == 0) {
            return null;
        }
        Project project = projects[0];
        return project;
    }
}

