/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex;

import com.intellij.lang.javascript.flex.ReferenceSupport;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class FlexConfigXmlReferenceContributor
extends PsiReferenceContributor {
    public static final String CLASS_REFERENCE = "ClassReference";

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/javascript/flex/FlexConfigXmlReferenceContributor", "registerReferenceProviders"));
        }
        XmlUtil.registerXmlTagReferenceProvider((PsiReferenceRegistrar)registrar, (String[])new String[]{"path-element", "class", "classname", "symbol"}, (ElementFilter)new NamespaceFilter(new String[]{"http://www.adobe.com/2006/flex-config"}), (boolean)true, (PsiReferenceProvider)new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/FlexConfigXmlReferenceContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/flex/FlexConfigXmlReferenceContributor$1", "getReferencesByElement"));
                }
                TextRange myRange = ElementManipulators.getValueTextRange((PsiElement)element);
                if (myRange.getStartOffset() == 0) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexConfigXmlReferenceContributor$1", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                XmlTag tag = (XmlTag)element;
                String trimmed = tag.getValue().getTrimmedText();
                if (trimmed.indexOf(123) != -1) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexConfigXmlReferenceContributor$1", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                if ("path-element".equals(tag.getLocalName())) {
                    PsiReference[] psiReferenceArray = ReferenceSupport.getFileRefs(element, myRange.getStartOffset(), trimmed, ReferenceSupport.LookupOptions.FLEX_COMPILER_CONFIG_PATH_ELEMENT);
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexConfigXmlReferenceContributor$1", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                PsiReference[] psiReferenceArray = new FlexConfigXmlReferenceSet(element, trimmed, myRange.getStartOffset()).getReferences();
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexConfigXmlReferenceContributor$1", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue((ElementPattern)XmlPatterns.xmlAttribute((String)"class").withParent((ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withName("component")).withParent((ElementPattern)XmlPatterns.xmlTag().withName("componentPackage")))), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/FlexConfigXmlReferenceContributor$2", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/flex/FlexConfigXmlReferenceContributor$2", "getReferencesByElement"));
                }
                TextRange myRange = ElementManipulators.getValueTextRange((PsiElement)element);
                if (myRange.getStartOffset() == 0) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexConfigXmlReferenceContributor$2", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String attrValue = ((XmlAttributeValue)element).getValue();
                PsiReference[] psiReferenceArray = new FlexConfigXmlReferenceSet(element, attrValue, myRange.getStartOffset()).getReferences();
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexConfigXmlReferenceContributor$2", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }

    static class FlexConfigXmlReferenceSet
    extends JSReferenceSet {
        public FlexConfigXmlReferenceSet(@NotNull PsiElement element, String text, int offset) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/FlexConfigXmlReferenceContributor$FlexConfigXmlReferenceSet", "<init>"));
            }
            super(element, text, offset, false, true);
        }

        protected int findSeparatorPosition(String s, int fromIndex) {
            int pos = s.indexOf(46, fromIndex);
            if (pos == -1 && s.indexOf(":") >= fromIndex) {
                pos = s.indexOf(":", fromIndex);
            }
            if (pos == -1 && s.indexOf("#") >= fromIndex) {
                pos = s.indexOf("#", fromIndex);
            }
            return pos;
        }
    }
}

