/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.rt;

import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.rt.RT;
import com.vladium.emma.rt.RTCoverageDataPersister;
import com.vladium.emma.rt.RTSettings;
import com.vladium.emma.rt.rpc.Request;
import com.vladium.emma.rt.rpc.Response;
import com.vladium.logging.Logger;
import com.vladium.util.IFileLock;
import com.vladium.util.Property;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;

final class RTController {
    private final int m_port;
    private Class m_RT;
    private ServerSocket m_ssocket;
    private Queue m_queue;
    private ListenThread m_listener;
    private ExecuteThread m_executor;
    private Thread m_listenThread;
    private Thread m_executeThread;
    private static final long THREAD_JOIN_TIMEOUT = 30000L;
    static /* synthetic */ Class class$com$vladium$emma$rt$RT;

    RTController(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port must be in [1, 65535] range: " + port);
        }
        this.m_RT = class$com$vladium$emma$rt$RT == null ? (class$com$vladium$emma$rt$RT = RTController.class$("com.vladium.emma.rt.RT")) : class$com$vladium$emma$rt$RT;
        this.m_port = port;
    }

    synchronized void start() throws IOException {
        if (this.m_ssocket != null) {
            throw new IllegalStateException("runtime controller already started");
        }
        Logger log = Logger.getLogger();
        log.verbose("starting runtime controller ...");
        this.m_ssocket = new ServerSocket(this.m_port);
        ThreadGroup controllerThreadGroup = new ThreadGroup("EMMA runtime thread group");
        controllerThreadGroup.setDaemon(true);
        this.m_queue = new Queue();
        ListenThread listener = new ListenThread(this, this.m_ssocket, this.m_queue);
        Thread listenThread = new Thread(controllerThreadGroup, listener, "EMMA runtime listen thread");
        listenThread.setDaemon(true);
        this.m_listener = listener;
        ExecuteThread executor = new ExecuteThread(this, this.m_queue);
        Thread executeThread = new Thread(controllerThreadGroup, executor, "EMMA runtime execute thread");
        executeThread.setDaemon(true);
        this.m_executor = executor;
        this.m_listenThread = listenThread;
        executeThread.start();
        this.m_executeThread = executeThread;
        listenThread.start();
        log.info("runtime controller started on port [" + this.m_port + "]");
    }

    synchronized void shutdown() {
        if (this.m_ssocket != null) {
            Logger log = Logger.getLogger();
            String method = "shutdown";
            log.verbose("shutting down runtime controller ...");
            this.m_listener.signalShutdown();
            this.m_listenThread.interrupt();
            try {
                this.m_ssocket.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            log.trace1("shutdown", "runtime control port socket closed");
            try {
                this.m_listenThread.join(30000L);
            }
            catch (InterruptedException ignore) {
                ignore.printStackTrace(System.out);
            }
            this.m_listenThread = null;
            this.m_listener = null;
            log.trace1("shutdown", "listen thread terminated");
            this.m_executor.signalShutdown();
            this.m_executeThread.interrupt();
            Socket currentRequestSocket = this.m_executor.currentRequestSocket();
            if (currentRequestSocket != null) {
                try {
                    currentRequestSocket.close();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            try {
                this.m_executeThread.join(30000L);
            }
            catch (InterruptedException ignore) {
                ignore.printStackTrace(System.out);
            }
            this.m_executeThread = null;
            this.m_executor = null;
            log.trace1("shutdown", "execute thread terminated");
            while (!this.m_queue.isEmpty()) {
                try {
                    RequestDescriptor rd = (RequestDescriptor)this.m_queue.dequeue();
                    try {
                        rd.m_socket.close();
                    }
                    catch (Exception ignore) {
                        ignore.printStackTrace(System.out);
                    }
                }
                catch (InterruptedException ignore) {
                    ignore.printStackTrace(System.out);
                }
            }
            this.m_queue = null;
            log.trace1("shutdown", "request queue aborted");
            this.m_ssocket = null;
            log.verbose("runtime controller shut down");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response execute(Request request) {
        String[] args = request.getArgs();
        int ID = request.getID();
        try {
            switch (ID) {
                case 0: {
                    int delay = Integer.parseInt(args[0]);
                    Thread.sleep(delay);
                    return new Response(ID, new Integer(delay));
                }
                case 1: {
                    ICoverageData cdata = RT.getCoverageData();
                    if (cdata != null) {
                        cdata = cdata.shallowCopy();
                        boolean disableShutdownHook = Property.toBoolean(args[2]);
                        if (disableShutdownHook) {
                            RT.reset(new RTSettings.SetActions(0, 0, 2, 0));
                        }
                    }
                    return new Response(ID, cdata);
                }
                case 2: {
                    ICoverageData cdata = RT.getCoverageData();
                    String trace = null;
                    if (cdata != null) {
                        File outFile = args[0] != null ? new File(args[0]) : RT.getCoverageOutFile();
                        boolean outMerge = args[1] != null ? Property.toBoolean(args[1]) : RT.getCoverageOutMerge();
                        boolean disableShutdownHook = args[2] != null ? Property.toBoolean(args[2]) : true;
                        IFileLock outLock = RT.getCoverageOutFileLock(outFile);
                        long start = System.currentTimeMillis();
                        RTCoverageDataPersister.dumpCoverageData(cdata, true, outFile, outMerge, outLock);
                        long end = System.currentTimeMillis();
                        trace = "runtime coverage data remotely " + (outMerge ? "merged into" : "written to") + " [" + outFile.getAbsolutePath() + "] {in " + (end - start) + " ms}";
                        if (disableShutdownHook) {
                            RT.reset(new RTSettings.SetActions(0, 0, 2, 0));
                        }
                    }
                    return new Response(ID, (Serializable)((Object)trace));
                }
                case 3: {
                    ICoverageData cdata = RT.getCoverageData();
                    int size = 0;
                    long start = System.currentTimeMillis();
                    if (cdata != null) {
                        Object disableShutdownHook = cdata.lock();
                        synchronized (disableShutdownHook) {
                            size = cdata.size();
                            if (size > 0) {
                                cdata.reset();
                            }
                        }
                    }
                    if (size > 0) {
                        long end = System.currentTimeMillis();
                        return new Response(ID, (Serializable)((Object)("coverage reset for " + size + " classes {in " + (end - start) + " ms}")));
                    }
                    return new Response(ID, (Serializable)((Object)("coverage reset for " + size + " classes")));
                }
            }
            throw new IllegalStateException("invalid request ID " + ID);
        }
        catch (Throwable t) {
            return new Response(ID, t);
        }
    }

    void reportError(String msg, Throwable t) {
        Logger log = Logger.getLogger();
        log.log(0, msg, t);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ExecuteThread
    implements Runnable {
        private final RTController m_controller;
        private final Queue m_queue;
        private Socket m_socket;
        private boolean m_shuttingDown;
        private static final int OUTPUT_IO_BUF_SIZE = 32768;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            log = Logger.getLogger();
            trace1 = log.atTRACE1();
            method = "run";
            while (!this.shutdownSignalled() && !Thread.interrupted()) {
                rd = null;
                try {
                    rd = (RequestDescriptor)this.m_queue.dequeue();
                    if (trace1) {
                        log.trace1("run", "dequeued request " + rd.m_request.getID());
                    }
                }
                catch (InterruptedException ie) {
                    var13_13 = null;
                    if (rd != null) {
                        try {
                            rd.m_socket.close();
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                    }
                    return;
                }
                response = this.m_controller.execute(rd.m_request);
                var6_8 = this;
                synchronized (var6_8) {
                    this.m_socket = rd.m_socket;
                }
                out = null;
                try {
                    out = new DataOutputStream(new BufferedOutputStream(this.m_socket.getOutputStream(), 32768));
                    Response.write(response, (DataOutputStream)out);
                    out.flush();
                    var9_11 = null;
                    ** if (out == null) goto lbl-1000
                }
                catch (Throwable var8_15) {
                    var9_11 = null;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                    }
                    throw var8_15;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        out.close();
                    }
                    catch (Exception ignore) {}
                }
lbl-1000:
                // 2 sources

                {
                }
                var7_9 = this;
                synchronized (var7_9) {
                    this.m_socket = null;
                }
                var13_13 = null;
                if (rd == null) continue;
                try {
                    rd.m_socket.close();
                }
                catch (Exception ignore) {}
                continue;
                {
                    catch (Throwable t) {
                        if (!this.shutdownSignalled()) {
                            this.m_controller.reportError("exception while processing a controller request", t);
                        }
                        var13_13 = null;
                        if (rd == null) continue;
                        try {
                            rd.m_socket.close();
                        }
                        catch (Exception ignore) {}
                        continue;
                    }
                }
                catch (Throwable var12_17) {
                    var13_13 = null;
                    if (rd != null) {
                        try {
                            rd.m_socket.close();
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                    }
                    throw var12_17;
                }
            }
        }

        synchronized Socket currentRequestSocket() {
            return this.m_socket;
        }

        synchronized void signalShutdown() {
            this.m_shuttingDown = true;
        }

        private synchronized boolean shutdownSignalled() {
            return this.m_shuttingDown;
        }

        ExecuteThread(RTController controller, Queue queue) {
            this.m_controller = controller;
            this.m_queue = queue;
        }
    }

    private static final class ListenThread
    implements Runnable {
        private final RTController m_controller;
        private final ServerSocket m_ssocket;
        private final Queue m_queue;
        private boolean m_shuttingDown;
        private static final int INPUT_IO_BUF_SIZE = 4096;

        public void run() {
            Logger log = Logger.getLogger();
            boolean trace1 = log.atTRACE1();
            String method = "run";
            while (!this.shutdownSignalled() && !Thread.interrupted()) {
                DataInputStream in = null;
                try {
                    Socket s = this.m_ssocket.accept();
                    long timestamp = System.currentTimeMillis();
                    in = new DataInputStream(new BufferedInputStream(s.getInputStream(), 4096));
                    Request request = Request.read(in);
                    in = null;
                    this.m_queue.enqueue(new RequestDescriptor(timestamp, s, request));
                    if (!trace1) continue;
                    log.trace1("run", "[" + timestamp + "] enqueued new request " + request.getID() + " @" + s.getInetAddress() + ":" + s.getPort());
                }
                catch (Throwable t) {
                    if (this.shutdownSignalled()) continue;
                    this.m_controller.reportError("exception while accepting a controller request", t);
                }
            }
        }

        synchronized void signalShutdown() {
            this.m_shuttingDown = true;
        }

        private synchronized boolean shutdownSignalled() {
            return this.m_shuttingDown;
        }

        ListenThread(RTController controller, ServerSocket ssocket, Queue queue) {
            this.m_controller = controller;
            this.m_ssocket = ssocket;
            this.m_queue = queue;
        }
    }

    private static final class Queue {
        private final LinkedList m_queue = new LinkedList();

        Queue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enqueue(Object item) {
            if (item == null) {
                throw new IllegalArgumentException("null input: item");
            }
            Queue queue = this;
            synchronized (queue) {
                this.m_queue.addFirst(item);
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object dequeue() throws InterruptedException {
            Queue queue = this;
            synchronized (queue) {
                while (this.m_queue.isEmpty()) {
                    this.wait();
                }
                return this.m_queue.removeLast();
            }
        }

        synchronized boolean isEmpty() {
            return this.m_queue.isEmpty();
        }
    }

    private static final class RequestDescriptor {
        final long m_timestamp;
        final Socket m_socket;
        final Request m_request;

        RequestDescriptor(long timestamp, Socket socket, Request request) {
            this.m_timestamp = timestamp;
            this.m_socket = socket;
            this.m_request = request;
        }
    }
}

