/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.view.editor;

import com.intellij.facet.Facet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.javaee.module.components.FrameworkElementAsVirtualFileImpl;
import com.intellij.javaee.module.components.FrameworkVirtualFileSystem;
import com.intellij.jpa.JpaMessages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.JavaeeIcons;
import com.intellij.util.xml.ElementPresentationManager;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistencePackageAsVirtualFileImpl<F extends Facet>
extends FrameworkElementAsVirtualFileImpl<F>
implements PersistencePackagePointer {
    @NonNls
    public static final String PERSISTENCE_UNIT_TYPE = "PersistenceModel";
    @NonNls
    private static final String ANONYMOUS_PREFIX = "noname-";

    PersistencePackageAsVirtualFileImpl(FacetPointer<F> facetPointer, String elementName) {
        super(facetPointer, PERSISTENCE_UNIT_TYPE, elementName);
    }

    @Nullable
    public PersistencePackage findElement() {
        PersistenceFacet facet = this.getPersistenceFacet();
        if (facet != null) {
            String elementName = this.getElementName();
            List units = facet.getPersistenceUnits();
            for (PersistencePackage unit : units) {
                if (!Comparing.equal((String)PersistencePackageAsVirtualFileImpl.getElementName(unit), (String)elementName)) continue;
                return unit;
            }
        }
        return null;
    }

    public PersistenceFacet getPersistenceFacet() {
        return (PersistenceFacet)this.getFacetPointer().getFacet();
    }

    @Override
    public String getPresentableName() {
        return JpaMessages.message((String)"persistence.unit.type", (Object[])new Object[0]) + " '" + this.getElementName() + "'";
    }

    @Override
    public Icon getIcon() {
        PersistencePackage unit = this.findElement();
        Icon icon = unit == null ? null : ElementPresentationManager.getIcon((Object)unit);
        return icon == null ? JavaeeIcons.PERSISTENCE_UNIT_ICON : icon;
    }

    @Nullable
    public static PersistencePackageAsVirtualFileImpl findFile(PersistencePackage unit, PersistenceFacet facet) {
        String path = PersistencePackageAsVirtualFileImpl.getPath(unit, facet);
        FrameworkVirtualFileSystem instance = FrameworkVirtualFileSystem.getJ2EEInstance();
        FrameworkElementAsVirtualFileImpl file = (FrameworkElementAsVirtualFileImpl)instance.findFileByPath(path);
        return (PersistencePackageAsVirtualFileImpl)file;
    }

    public static String getPath(PersistencePackage unit, PersistenceFacet facet) {
        String name = PersistencePackageAsVirtualFileImpl.getElementName(unit);
        return FrameworkVirtualFileSystem.getPath(facet.getModule().getProject(), FacetPointersManager.constructId((Facet)((Facet)facet)), PERSISTENCE_UNIT_TYPE, name);
    }

    @NotNull
    public static String getElementName(@NotNull PersistencePackage unit) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/jpa/view/editor/PersistencePackageAsVirtualFileImpl", "getElementName"));
        }
        String unitName = (String)unit.getName().getValue();
        XmlTag tag = unit.getXmlTag();
        PsiFile containingFile = unit.getContainingFile();
        if (StringUtil.isEmpty((String)unitName) && tag != null && containingFile != null) {
            unitName = ANONYMOUS_PREFIX + containingFile.getName() + '@' + tag.getTextOffset();
        }
        String string = StringUtil.notNullize((String)unitName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/view/editor/PersistencePackageAsVirtualFileImpl", "getElementName"));
        }
        return string;
    }
}

