/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.view;

import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.view.EntityListenerBindingsPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.PsiNameHelper;
import javax.swing.JComponent;

public class EntityListenerBindingsDialog
extends DialogWrapper {
    private final EntityListenerBindingsPanel myEntityListenerBindingsPanel;

    public <U extends PersistencePackage, T extends PersistenceFacet> EntityListenerBindingsDialog(Project project, String entityListenerClass, T facet) {
        super(project, true);
        this.myEntityListenerBindingsPanel = new EntityListenerBindingsPanel(project, facet, entityListenerClass){

            @Override
            protected void updateOKAction() {
                EntityListenerBindingsDialog.this.setOKActionEnabled(this.isOKActionEnabled());
            }
        };
        this.setTitle(JpaMessages.message((String)"dialog.title.edit.entity.listener.bindings", (Object[])new Object[]{PsiNameHelper.getShortClassName((String)entityListenerClass)}));
        this.init();
    }

    protected void doOKAction() {
        if (!this.myEntityListenerBindingsPanel.isDataValid()) {
            return;
        }
        this.myEntityListenerBindingsPanel.applyEntityListenerBindings();
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        return this.myEntityListenerBindingsPanel.getComponent();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEntityListenerBindingsPanel.getPreferredFocusedComponent();
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.myEntityListenerBindingsPanel);
        super.dispose();
    }
}

