/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.types;

import com.intellij.jpa.ql.types.QlCollectionType;
import com.intellij.jpa.ql.types.QlType;
import org.jetbrains.annotations.NotNull;

public class QlIndexedCollectionType
extends QlCollectionType {
    private final QlType myIndexType;

    public QlIndexedCollectionType(@NotNull QlType indexType, @NotNull QlType componentType) {
        if (indexType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexType", "com/intellij/jpa/ql/types/QlIndexedCollectionType", "<init>"));
        }
        if (componentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentType", "com/intellij/jpa/ql/types/QlIndexedCollectionType", "<init>"));
        }
        super(componentType);
        this.myIndexType = indexType;
    }

    @NotNull
    public QlType getIndexType() {
        QlType qlType = this.myIndexType;
        if (qlType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/types/QlIndexedCollectionType", "getIndexType"));
        }
        return qlType;
    }

    @Override
    @NotNull
    public QlType getComponentType() {
        QlType qlType = this.myComponentType;
        if (qlType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/types/QlIndexedCollectionType", "getComponentType"));
        }
        return qlType;
    }

    public QlType getEntryType() {
        return new EntryType();
    }

    @Override
    @NotNull
    public String getName() {
        String string = "indexed collection of " + this.myIndexType.getName() + "->" + this.myComponentType.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/types/QlIndexedCollectionType", "getName"));
        }
        return string;
    }

    public class EntryType
    extends QlType {
        public EntryType() {
            super("map entry");
        }

        QlIndexedCollectionType getCollectionType() {
            return QlIndexedCollectionType.this;
        }
    }
}

