/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.parser;

import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.ql.parser.QlLexer;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.tree.IElementType;

public class QlParserUtil
extends GeneratedParserUtilBase {
    public static boolean identifierOrToken(PsiBuilder builder_, int level) {
        if (QlParserUtil.consumeToken((PsiBuilder)builder_, (IElementType)QlLexer.QL_IDENTIFIER)) {
            return true;
        }
        String tokenText = builder_.getTokenText();
        if (tokenText != null && ((QlLexer)((GeneratedParserUtilBase.Builder)builder_).getLexer()).getKeywords().contains(tokenText)) {
            builder_.remapCurrentToken(QlLexer.QL_IDENTIFIER);
            builder_.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean isQlDialect(PsiBuilder builder_, int level, int dialect) {
        Language language = QlParserUtil.getLanguage(builder_);
        if (dialect == 1) {
            return language == JpqlLanguage.EJBQL;
        }
        if (dialect == 2) {
            return language == JpqlLanguage.HQL;
        }
        if (dialect == 3) {
            return language == JpqlLanguage.EQL;
        }
        return false;
    }

    public static boolean hqlType(PsiBuilder builder_, int level) {
        for (String type : QlLexer.HQL_ALL_TYPES) {
            if (!QlParserUtil.consumeToken((PsiBuilder)builder_, (String)type)) continue;
            return true;
        }
        return false;
    }

    public static boolean hqlDatetimeType(PsiBuilder builder_, int level) {
        for (String type : QlLexer.HQL_DATETIME_TYPES) {
            if (!QlParserUtil.consumeToken((PsiBuilder)builder_, (String)type)) continue;
            return true;
        }
        return false;
    }

    private static Language getLanguage(PsiBuilder builder_) {
        PsiFile file = (PsiFile)builder_.getUserDataUnprotected(FileContextUtil.CONTAINING_FILE_KEY);
        assert (file != null);
        return file.getLanguage();
    }
}

