/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql;

import com.intellij.jpa.ql.parser.QlLexer;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class QlNamesValidator
implements NamesValidator {
    public boolean isIdentifier(@NotNull String name, Project project) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/jpa/ql/QlNamesValidator", "isIdentifier"));
        }
        return StringUtil.isJavaIdentifier((String)name) && name.indexOf(36) == -1 && (!this.isKeyword(name, project) || QlLexer.isOptionalKeyword(name));
    }

    public boolean isKeyword(@NotNull String name, Project project) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/jpa/ql/QlNamesValidator", "isKeyword"));
        }
        return QlLexer.JPA_KEYWORDS.containsKey(name);
    }

    public static class Hql
    extends QlNamesValidator {
        @Override
        public boolean isKeyword(@NotNull String name, Project project) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/jpa/ql/QlNamesValidator$Hql", "isKeyword"));
            }
            return QlLexer.HQL_KEYWORDS.containsKey(name);
        }
    }

    public static class Ejbql
    extends QlNamesValidator {
        @Override
        public boolean isKeyword(@NotNull String name, Project project) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/jpa/ql/QlNamesValidator$Ejbql", "isKeyword"));
            }
            return QlLexer.EJB_KEYWORDS.containsKey(name);
        }
    }
}

