/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.providers;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.jpa.JpaImplementationProviderBase;
import com.intellij.jpa.util.JpaUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenJPAProvider
extends JpaImplementationProviderBase {
    @NonNls
    private static final String PROVIDER_CLASS = "org.apache.openjpa.persistence.PersistenceProviderImpl";
    @NonNls
    public static final String DRIVER = "openjpa.ConnectionDriverName";
    @NonNls
    public static final String URL = "openjpa.ConnectionURL";
    @NonNls
    public static final String USER = "openjpa.ConnectionUserName";
    @NonNls
    public static final String PASSWORD = "openjpa.ConnectionPassword";
    @NonNls
    public static final String LOGGING = "openjpa.Log";

    public OpenJPAProvider() {
        super("OpenJPA", PROVIDER_CLASS, DRIVER, URL, USER, PASSWORD);
    }

    @Nullable
    public Icon getProviderIcon() {
        return AllIcons.Providers.Apache;
    }

    @Override
    public void setDefaultProperties(@NotNull PersistenceUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/jpa/providers/OpenJPAProvider", "setDefaultProperties"));
        }
        super.setDefaultProperties(unit);
        JpaUtil.setPersistenceUnitProperty(unit, LOGGING, null, "DefaultLevel=TRACE, Tool=INFO");
    }
}

