/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.providers;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.jpa.JpaImplementationProviderBase;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HibernateProvider
extends JpaImplementationProviderBase {
    @NonNls
    public static final String PROVIDER_JPA_21 = "org.hibernate.jpa.HibernatePersistenceProvider";
    @NonNls
    public static final String PROVIDER_JPA_20 = "org.hibernate.ejb.HibernatePersistence";
    @NonNls
    public static final String HIBERNATE_PREFIX = "hibernate.";
    @NonNls
    public static final String DRIVER = "hibernate.connection.driver_class";
    @NonNls
    public static final String URL = "hibernate.connection.url";
    @NonNls
    public static final String USER = "hibernate.connection.username";
    @NonNls
    public static final String PASSWORD = "hibernate.connection.password";

    public HibernateProvider() {
        super("Hibernate", PROVIDER_JPA_21, DRIVER, URL, USER, PASSWORD);
    }

    @Nullable
    public Icon getProviderIcon() {
        return AllIcons.Providers.Hibernate;
    }

    @Override
    @Nullable
    protected String getPropertyAlias(String propertyName) {
        return propertyName.substring(HIBERNATE_PREFIX.length());
    }

    @Override
    public void setDefaultProperties(@NotNull PersistenceUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/jpa/providers/HibernateProvider", "setDefaultProperties"));
        }
        super.setDefaultProperties(unit);
        JpaUtil.setPersistenceUnitProperty(unit, "hibernate.archive.autodetection", null, "class");
        JpaUtil.setPersistenceUnitProperty(unit, "hibernate.show_sql", null, "true");
        JpaUtil.setPersistenceUnitProperty(unit, "hibernate.format_sql", null, "true");
        JpaUtil.setPersistenceUnitProperty(unit, "hibernate.format_sql", null, "true");
        JpaUtil.setPersistenceUnitProperty(unit, "hbm2ddl.auto", null, "update");
    }

    @Override
    public String getProviderClassName(@Nullable Module module) {
        return HibernateProvider.getProvider(module);
    }

    @NotNull
    public static String getProvider(@Nullable Module module) {
        if (module != null && JavaPsiFacade.getInstance((Project)module.getProject()).findClass(PROVIDER_JPA_21, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) != null) {
            if (PROVIDER_JPA_21 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/providers/HibernateProvider", "getProvider"));
            }
            return PROVIDER_JPA_21;
        }
        if (PROVIDER_JPA_20 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/providers/HibernateProvider", "getProvider"));
        }
        return PROVIDER_JPA_20;
    }
}

