/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.packaging;

import com.intellij.facet.Facet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.packaging.JpaDescriptorsNodePresentation;
import com.intellij.jpa.packaging.JpaDescriptorsPackagingElementType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.ui.DelegatedPackagingElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.packaging.ui.TreeNodePresentation;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaDescriptorsPackagingElement
extends ComplexPackagingElement<JpaDescriptorsPackagingElementState> {
    private FacetPointer<JpaFacet> myFacetPointer;
    private final Project myProject;

    public JpaDescriptorsPackagingElement(Project project, JpaFacet facet) {
        super((PackagingElementType)JpaDescriptorsPackagingElementType.getInstance());
        this.myProject = project;
        this.myFacetPointer = facet != null ? FacetPointersManager.getInstance((Project)project).create((Facet)facet) : null;
    }

    public List<? extends PackagingElement<?>> getSubstitution(@NotNull PackagingElementResolvingContext context, @NotNull ArtifactType artifactType) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jpa/packaging/JpaDescriptorsPackagingElement", "getSubstitution"));
        }
        if (artifactType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactType", "com/intellij/jpa/packaging/JpaDescriptorsPackagingElement", "getSubstitution"));
        }
        JpaFacet facet = this.getFacet();
        if (facet != null) {
            ConfigFileMetaData metaData;
            ArrayList<PackagingElement> descriptors = new ArrayList<PackagingElement>();
            ConfigFile mainDd = facet.getMainDeploymentDescriptor();
            ConfigFile defOrmDd = facet.getDefaultORMDescriptor();
            VirtualFile persistenceXml = mainDd != null ? mainDd.getVirtualFile() : null;
            VirtualFile defOrmXml = defOrmDd != null ? defOrmDd.getVirtualFile() : null;
            PackagingElementFactory factory = PackagingElementFactory.getInstance();
            if (persistenceXml != null) {
                metaData = mainDd.getMetaData();
                descriptors.add(factory.createFileCopyWithParentDirectories(persistenceXml.getPath(), metaData.getDirectoryPath(), metaData.getFileName()));
            }
            if (defOrmXml != null) {
                metaData = defOrmDd.getMetaData();
                descriptors.add(factory.createFileCopyWithParentDirectories(defOrmXml.getPath(), metaData.getDirectoryPath(), metaData.getFileName()));
            }
            return descriptors;
        }
        return Collections.emptyList();
    }

    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jpa/packaging/JpaDescriptorsPackagingElement", "createPresentation"));
        }
        return new DelegatedPackagingElementPresentation((TreeNodePresentation)new JpaDescriptorsNodePresentation(this.myFacetPointer));
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/packaging/JpaDescriptorsPackagingElement", "isEqualTo"));
        }
        return element instanceof JpaDescriptorsPackagingElement && this.myFacetPointer != null && this.myFacetPointer.equals(((JpaDescriptorsPackagingElement)element).myFacetPointer);
    }

    public JpaDescriptorsPackagingElementState getState() {
        JpaDescriptorsPackagingElementState state = new JpaDescriptorsPackagingElementState();
        state.myFacetPointer = this.myFacetPointer != null ? this.myFacetPointer.getId() : null;
        return state;
    }

    public void loadState(JpaDescriptorsPackagingElementState state) {
        String pointer = state.myFacetPointer;
        this.myFacetPointer = pointer != null ? FacetPointersManager.getInstance((Project)this.myProject).create(pointer) : null;
    }

    @NotNull
    public PackagingElementOutputKind getFilesKind(PackagingElementResolvingContext context) {
        PackagingElementOutputKind packagingElementOutputKind = PackagingElementOutputKind.DIRECTORIES_WITH_CLASSES;
        if (packagingElementOutputKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/packaging/JpaDescriptorsPackagingElement", "getFilesKind"));
        }
        return packagingElementOutputKind;
    }

    public String toString() {
        return "jpa-resources:" + this.myFacetPointer.getFacetName() + "(" + this.myFacetPointer.getModuleName() + ")";
    }

    @Nullable
    public JpaFacet getFacet() {
        return this.myFacetPointer != null ? (JpaFacet)this.myFacetPointer.getFacet() : null;
    }

    public static class JpaDescriptorsPackagingElementState {
        @Attribute(value="facet")
        public String myFacetPointer;
    }
}

