/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.intentions;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.javaee.model.common.persistence.mapping.EntityListener;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.jpa.view.EntityListenerBindingsDialog;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaEntityListenerBindingsAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/intentions/JpaEntityListenerBindingsAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/intentions/JpaEntityListenerBindingsAction", "isAvailable"));
        }
        if (element instanceof PsiWhiteSpace) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof PsiJavaFile) || file.getLanguage() != StdLanguages.JAVA) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (targetClass == null || !targetClass.isValid() || targetClass.getQualifiedName() == null) {
            return false;
        }
        if (!HighlightNamesUtil.getClassDeclarationTextRange((PsiClass)targetClass).containsRange(offset, offset + 1)) {
            return false;
        }
        PsiDocComment docComment = targetClass.getDocComment();
        if (docComment != null && docComment.getTextRange().containsRange(offset, offset + 1)) {
            return false;
        }
        if (PsiTreeUtil.getChildOfType((PsiElement)targetClass, PsiErrorElement.class) != null) {
            return false;
        }
        String text = JpaEntityListenerBindingsAction.getExplanation(targetClass);
        if (text != null) {
            this.setText(text);
            return true;
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = JpaMessages.message((String)"intention.persistence.edit.entity.listener.bindings.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/intentions/JpaEntityListenerBindingsAction", "getFamilyName"));
        }
        return string;
    }

    @Nullable
    public static String getExplanation(PsiClass psiClass) {
        if (JpaUtil.getFirstPersistenceRoleWithClass(psiClass, EntityListener.class) != null) {
            return JpaMessages.message((String)"intention.persistence.edit.entity.listener.bindings.text", (Object[])new Object[]{psiClass.getName()});
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/intentions/JpaEntityListenerBindingsAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/intentions/JpaEntityListenerBindingsAction", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        assert (targetClass != null);
        PersistenceClassRole classRole = JpaUtil.getFirstPersistenceRoleWithClass(targetClass, EntityListener.class);
        EntityListenerBindingsDialog dialog = new EntityListenerBindingsDialog(project, targetClass.getQualifiedName(), classRole.getFacet());
        dialog.show();
    }

    public boolean startInWriteAction() {
        return false;
    }
}

