/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import java.text.MessageFormat;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class JpaInspectionUtil {
    public static final Logger LOG = Logger.getInstance((String)JpaInspectionUtil.class.getName());

    private JpaInspectionUtil() {
    }

    public static LocalQuickFix convertToQuickFix(final IntentionAction quickFix) {
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = quickFix.getText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/highlighting/JpaInspectionUtil$1", "getName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/highlighting/JpaInspectionUtil$1", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/jpa/highlighting/JpaInspectionUtil$1", "applyFix"));
                }
                try {
                    PsiElement element = descriptor.getPsiElement();
                    PsiFile containingFile = element.getContainingFile();
                    int offset = element.getTextRange().getStartOffset();
                    Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, containingFile.getVirtualFile(), offset), false);
                    if (quickFix.isAvailable(project, editor, containingFile)) {
                        quickFix.invoke(project, editor, containingFile);
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }

            @NotNull
            public String getFamilyName() {
                String string = quickFix.getFamilyName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/highlighting/JpaInspectionUtil$1", "getFamilyName"));
                }
                return string;
            }
        };
    }

    public static boolean processAllLiteralExpressions(PsiElement root, final Function<PsiElement, PsiElement> elementFilter, final Processor<PsiLiteralExpression> processor) {
        final Ref ref = new Ref((Object)Boolean.TRUE);
        root.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                if (!((Boolean)ref.get()).booleanValue()) {
                    return;
                }
                if ((element = (PsiElement)elementFilter.fun((Object)element)) instanceof PsiLiteralExpression && !processor.process((Object)((PsiLiteralExpression)element))) {
                    ref.set((Object)Boolean.FALSE);
                } else if (element != null) {
                    super.visitElement(element);
                }
            }
        });
        return (Boolean)ref.get();
    }

    public static <T extends PsiReference & EmptyResolveMessageProvider> boolean checkRelatedReferencesInLiterals(PsiElement root, ProblemsHolder holder, Class<T> referenceClass, Function<PsiElement, PsiElement> elementFilter) {
        Ref hasErrors = new Ref((Object)Boolean.FALSE);
        Processor processor = t -> {
            boolean badResolve;
            boolean bl = t instanceof PsiPolyVariantReference ? ((PsiPolyVariantReference)t).multiResolve(false).length == 0 : (badResolve = t.resolve() == null);
            if (badResolve) {
                String message = MessageFormat.format(((EmptyResolveMessageProvider)t).getUnresolvedMessagePattern(), t.getCanonicalText());
                holder.registerProblem(holder.getManager().createProblemDescriptor(t.getElement(), t.getRangeInElement(), message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, holder.isOnTheFly(), ((LocalQuickFixProvider)t).getQuickFixes()));
                hasErrors.set((Object)Boolean.TRUE);
                return true;
            }
            return true;
        };
        JpaInspectionUtil.processAllLiteralExpressions(root, elementFilter, (Processor<PsiLiteralExpression>)((Processor)literal -> JpaUtil.processReferencesOfType(literal.getReferences(), referenceClass, processor)));
        return (Boolean)hasErrors.get() == false;
    }

    public static <T extends PsiReference & EmptyResolveMessageProvider> boolean checkMemberAnnotations(PsiModifierListOwner psiMember, ProblemsHolder holder, Class<T> aClass) {
        PsiModifierList list = psiMember.getModifierList();
        return list == null || JpaInspectionUtil.checkRelatedReferencesInLiterals((PsiElement)list, holder, aClass, (Function<PsiElement, PsiElement>)((NullableFunction)element -> {
            PsiAnnotation psiAnnotation;
            String qualifiedName;
            if (element instanceof PsiAnnotation && ((qualifiedName = (psiAnnotation = (PsiAnnotation)element).getQualifiedName()) == null || !qualifiedName.startsWith("javax.persistence."))) {
                return null;
            }
            return element;
        }));
    }

    public static boolean checkMethodParameters(PsiMethod psiMethod, ProblemsHolder holder, PsiType ... types) {
        boolean result = true;
        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            PsiType parameterType = parameter.getType();
            if (i < types.length) {
                PsiType type = types[i];
                if (parameterType.equals(type)) continue;
                holder.registerProblem((PsiElement)parameter, JpaHighlightingMessages.message("method.0.should.take.parameter.of.type.1.here", psiMethod.getName(), type), new LocalQuickFix[]{JpaInspectionUtil.convertToQuickFix((IntentionAction)QuickFixFactory.getInstance().createMethodParameterTypeFix(psiMethod, i, type, true))});
                result = false;
                continue;
            }
            if (i != types.length) continue;
            holder.registerProblem((PsiElement)parameter, JpaHighlightingMessages.message("method.0.should.take.1.parameters.only", psiMethod.getName(), types.length), new LocalQuickFix[]{QuickFixFactory.getInstance().createRemoveUnusedParameterFix(parameter)});
            result = false;
        }
        if (parameters.length < types.length) {
            holder.registerProblem((PsiElement)psiMethod.getParameterList(), JpaHighlightingMessages.message("method.0.should.take.parameter.of.type.1.here", psiMethod.getName(), types[parameters.length]), new LocalQuickFix[]{QuickFixFactory.getInstance().createMethodParameterTypeFix(psiMethod, parameters.length, types[parameters.length], true)});
            result = false;
        }
        return result;
    }

    public static boolean checkMethodReturnType(PsiMethod psiMethod, ProblemsHolder holder, PsiType returnType) {
        if (!returnType.equals(psiMethod.getReturnType())) {
            PsiTypeElement element;
            PsiTypeElement typeElement = psiMethod.getReturnTypeElement();
            Object object = element = typeElement != null ? typeElement : psiMethod.getNameIdentifier();
            if (element == null) {
                return false;
            }
            holder.registerProblem((PsiElement)element, JpaHighlightingMessages.message("method.0.should.return.1", psiMethod.getName(), returnType.getCanonicalText()), new LocalQuickFix[]{QuickFixFactory.getInstance().createMethodReturnFix(psiMethod, returnType, false)});
            return false;
        }
        return true;
    }

    public static boolean checkNoArgConstructorExists(PsiClass aClass, ProblemsHolder holder, String ... allowedModifiers) {
        if (aClass.getConstructors().length > 0) {
            for (PsiMethod psiMethod : aClass.getConstructors()) {
                if (!Arrays.asList(allowedModifiers).contains(PsiUtil.getAccessModifier((int)PsiUtil.getAccessLevel((PsiModifierList)psiMethod.getModifierList()))) || psiMethod.getParameterList().getParametersCount() != 0) continue;
                return true;
            }
            PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
            if (nameIdentifier == null) {
                return false;
            }
            holder.registerProblem((PsiElement)nameIdentifier, JpaHighlightingMessages.message("class.0.should.have.1.no.arg.constructor", aClass.getName(), Arrays.asList(allowedModifiers)), new LocalQuickFix[]{JpaInspectionUtil.convertToQuickFix((IntentionAction)QuickFixFactory.getInstance().createAddDefaultConstructorFix(aClass))});
            return false;
        }
        return true;
    }

    public static boolean checkClassExtends(PsiClass aClass, String baseClass, boolean shouldExtend, PsiElement anchor, ProblemsHolder holder) {
        if (anchor == null || aClass == null) {
            return false;
        }
        PsiClass aBaseClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass(baseClass, GlobalSearchScope.allScope((Project)aClass.getProject()));
        if (aBaseClass == null) {
            return false;
        }
        if (aClass.isInheritor(aBaseClass, true) != shouldExtend) {
            String message = aClass.isInterface() ? JpaHighlightingMessages.message(shouldExtend ? "interface.should.extend" : "interface.should.not.extend", aClass.getName(), baseClass) : (aBaseClass.isInterface() == aClass.isInterface() ? JpaHighlightingMessages.message(shouldExtend ? "class.should.extend" : "class.should.not.extend", aClass.getName(), baseClass) : JpaHighlightingMessages.message(shouldExtend ? "class.should.implement" : "class.should.not.implement", aClass.getName(), baseClass));
            holder.registerProblem(anchor, message, new LocalQuickFix[]{QuickFixFactory.getInstance().createExtendsListFix(aClass, JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(aBaseClass), shouldExtend)});
            return true;
        }
        return false;
    }
}

