/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.facet.ui;

import com.intellij.facet.Facet;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.libraries.FacetLibrariesValidator;
import com.intellij.javaee.JavaeePersistenceDescriptorsConstants;
import com.intellij.javaee.ui.ConfigFilesEditor;
import com.intellij.javaee.ui.DeploymentDescriptorsOwnerBase;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.facet.JpaFacetConfiguration;
import com.intellij.jpa.facet.JpaFrameworkSupportProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import com.intellij.util.descriptors.ConfigFileMetaData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaGeneralEditorTab
extends FacetEditorTab {
    private JPanel myMainPanel;
    private JPanel myDescriptorsPanel;
    private JComboBox myProviderComboBox;
    private ConfigFilesEditor myConfigFilesEditor;
    private DeploymentDescriptorsOwnerBase myDescriptorsOwner;
    private ConfigFileInfoSet myFileInfoSet;
    private final JpaFacetConfiguration myConfiguration;
    private final FacetLibrariesValidator myLibrariesValidator;

    public JpaGeneralEditorTab(JpaFacetConfiguration configuration, FacetEditorContext editorContext, FacetLibrariesValidator validator) {
        this.myConfiguration = configuration;
        this.myLibrariesValidator = validator;
        this.$$$setupUI$$$();
        JpaFacet facet = (JpaFacet)editorContext.getFacet();
        JpaFrameworkSupportProvider.setupJpaProvidersCombobox(this.myProviderComboBox);
        this.createDescriptorsEditor(editorContext);
    }

    private void createDescriptorsEditor(FacetEditorContext editorContext) {
        this.myDescriptorsOwner = new DeploymentDescriptorsOwnerBase(editorContext){

            @Override
            public boolean canBeParentForDescriptors(VirtualFile dir) {
                return true;
            }
        };
        ConfigFileMetaData[] metaData = new ConfigFileMetaData[]{JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA, JavaeePersistenceDescriptorsConstants.ORM_XML_META_DATA};
        JpaFacet facet = (JpaFacet)editorContext.getFacet();
        this.myFileInfoSet = ((JpaFacetConfiguration)facet.getConfiguration()).getDescriptorsConfiguration();
        Module module = editorContext.getModule();
        File defaultParent = new File(module.getModuleFilePath()).getAbsoluteFile().getParentFile();
        this.myConfigFilesEditor = new ConfigFilesEditor(metaData, this.myFileInfoSet, defaultParent, editorContext.isNewFacet(), this.myDescriptorsOwner, false);
        this.myDescriptorsPanel.setLayout(new BorderLayout());
        this.myDescriptorsPanel.add((Component)this.myConfigFilesEditor.createComponent(), "Center");
    }

    @Nls
    public String getDisplayName() {
        return JpaMessages.message((String)"tab.title.jpa.general.settings", (Object[])new Object[0]);
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/facet/ui/JpaGeneralEditorTab", "createComponent"));
        }
        return jPanel;
    }

    public boolean isModified() {
        if (this.myConfigFilesEditor.isModified()) {
            return true;
        }
        JpaImplementationProvider provider = (JpaImplementationProvider)this.myProviderComboBox.getSelectedItem();
        if (!Comparing.equal((String)this.myConfiguration.getDefaultJPAProviderName(), (String)(provider == null ? null : provider.getProviderName()))) {
            return true;
        }
        return this.myLibrariesValidator.isLibrariesAdded();
    }

    public void apply() throws ConfigurationException {
        this.myConfigFilesEditor.applyChanges();
        JpaImplementationProvider provider = (JpaImplementationProvider)this.myProviderComboBox.getSelectedItem();
        this.myConfiguration.setDefaultJPAProviderName(provider == null ? null : provider.getProviderName());
    }

    public void reset() {
        this.myProviderComboBox.setSelectedItem(JpaFrameworkSupportProvider.findProviderByName(this.myConfiguration.getDefaultJPAProviderName()));
    }

    public void onFacetInitialized(@NotNull Facet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/jpa/facet/ui/JpaGeneralEditorTab", "onFacetInitialized"));
        }
        this.myDescriptorsOwner.createAndDeleteFiles(facet.getModule().getProject());
        ((JpaFacetConfiguration)((JpaFacet)facet).getConfiguration()).getDescriptorsConfiguration().setConfigFileInfos(Arrays.asList(this.myFileInfoSet.getConfigFileInfos()));
        this.myLibrariesValidator.onFacetInitialized(facet);
    }

    public void disposeUIResources() {
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settings.module.facet.hibernate.jpa";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDescriptorsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/JpaBundle").getString("border.facet.descriptors"), (int)0, (int)0, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myProviderComboBox = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/JpaBundle").getString("label.facet.default.jpa.provider"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

