/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetFinder;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerListener;
import com.intellij.facet.FacetType;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.JavaeePersistenceDescriptorsConstants;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.model.common.persistence.mapping.EntityMappings;
import com.intellij.javaee.model.xml.persistence.Persistence;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.javaee.model.xml.persistence.mapping.AccessType;
import com.intellij.javaee.model.xml.persistence.mapping.PersistenceUnitDefaults;
import com.intellij.jpa.JpaInspectionToolProvider;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.facet.JpaFacetConfiguration;
import com.intellij.jpa.highlighting.HibernateModelValidator;
import com.intellij.jpa.highlighting.JpaModelValidator;
import com.intellij.jpa.highlighting.JpaModelValidatorBase;
import com.intellij.jpa.model.ImplicitPersistenceUnit;
import com.intellij.jpa.model.annotations.mapping.EntityMappingsImpl;
import com.intellij.jpa.model.common.MergedPersistenceMappings;
import com.intellij.jpa.model.xml.impl.converters.PersistentUnitFileConverterImpl;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.util.JpaCommonUtil;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.jpa.view.editor.PersistencePackageAsVirtualFileImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.extensions.PersistencePackagesProvider;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.facet.PersistencePackageDefaults;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.model.validators.ModelValidator;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileAdapter;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileListener;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.GenericValueUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaFacetImpl
extends JpaFacet {
    private EntityMappingsImpl myAnnotationsPersistenceRoot;
    private CachedValue<List<XmlFile>> myMyCachedXmls;
    private final ConfigFileContainer myDescriptorsContainer;
    private final UnitDataSourceMap myUnitDataSourceMap;
    private static final Key<CachedValue<Condition<PsiClass>>> ANNO_MAPPINGS_CONDITION = Key.create((String)"ANNO_MAPPINGS_CONDITION");
    private static final Key<CachedValue<PersistencePackageDefaults>> PERSISTENCE_UNIT_DEFAULTS = Key.create((String)"PERSISTENCE_UNIT_DEFAULTS");

    public JpaFacetImpl(@NotNull FacetType<JpaFacet, JpaFacetConfiguration> facetType, @NotNull Module module, String name, @NotNull JpaFacetConfiguration configuration, Facet underlyingFacet) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetType", "com/intellij/jpa/facet/JpaFacetImpl", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jpa/facet/JpaFacetImpl", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/jpa/facet/JpaFacetImpl", "<init>"));
        }
        super(facetType, module, name, configuration, underlyingFacet);
        this.myUnitDataSourceMap = new UnitDataSourceMap(configuration.getUnitToDataSourceMap(), (PersistenceFacet)this);
        this.myDescriptorsContainer = ConfigFileFactory.getInstance().createConfigFileContainer(this.getModule().getProject(), configuration.getDescriptorsConfiguration().getMetaDataProvider(), configuration.getDescriptorsConfiguration());
        this.myDescriptorsContainer.addListener((ConfigFileListener)new ConfigFileAdapter(){

            protected void configChanged(ConfigFile configFile) {
                ((FacetManagerListener)JpaFacetImpl.this.getModule().getMessageBus().syncPublisher(FacetManager.FACETS_TOPIC)).facetConfigurationChanged((Facet)JpaFacetImpl.this);
            }
        });
        Disposer.register((Disposable)this, (Disposable)this.myDescriptorsContainer);
    }

    public void initFacet() {
        JavaeeUtil.installDomAndJamListeners((Facet)this, this.myDescriptorsContainer);
    }

    public void disposeFacet() {
    }

    @Nullable
    public ConfigFile getMainDeploymentDescriptor() {
        return this.myDescriptorsContainer.getConfigFile(JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA);
    }

    public ConfigFile getDefaultORMDescriptor() {
        return this.myDescriptorsContainer.getConfigFile(JavaeePersistenceDescriptorsConstants.ORM_XML_META_DATA);
    }

    public ConfigFile[] getDescriptors() {
        return this.myDescriptorsContainer.getConfigFiles();
    }

    @Nullable
    public Persistence getPersistenceRoot() {
        XmlFile xmlFile = this.getPersistenceXmlInModule();
        if (xmlFile != null) {
            return (Persistence)JamCommonUtil.getRootElement((PsiFile)xmlFile, Persistence.class, (Module)this.getModule());
        }
        return null;
    }

    @Nullable
    public Persistence getMergedPersistenceRoot() {
        List<XmlFile> list = this.getPersistenceXmls();
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            LinkedHashSet roots = new LinkedHashSet();
            for (XmlFile xmlFile : list) {
                ContainerUtil.addIfNotNull(roots, (Object)JamCommonUtil.getRootElement((PsiFile)xmlFile, Persistence.class, (Module)this.getModule()));
            }
            return (Persistence)DomService.getInstance().createModelMerger().mergeModels(Persistence.class, roots);
        }
        return (Persistence)JamCommonUtil.getRootElement((PsiFile)((PsiFile)list.get(0)), Persistence.class, (Module)this.getModule());
    }

    @Nullable
    public EntityMappings getAnnotationEntityMappings() {
        this.refreshModel();
        return this.myAnnotationsPersistenceRoot;
    }

    @NotNull
    public List<PersistencePackage> getPersistenceUnits() {
        ArrayList<PersistencePackage> packages = new ArrayList<PersistencePackage>();
        Persistence persistenceRoot = this.getMergedPersistenceRoot();
        if (persistenceRoot != null) {
            packages.addAll(persistenceRoot.getPersistenceUnits());
        }
        packages.addAll(this.getExtensionPersistenceUnits());
        if (packages.isEmpty()) {
            ContainerUtil.addIfNotNull(packages, (Object)((Object)this.getImplicitPersistenceUnit()));
        }
        ArrayList<PersistencePackage> arrayList = packages;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/facet/JpaFacetImpl", "getPersistenceUnits"));
        }
        return arrayList;
    }

    @Nullable
    protected ImplicitPersistenceUnit getImplicitPersistenceUnit() {
        return (ImplicitPersistenceUnit)((Object)CachedValuesManager.getManager((Project)this.getModule().getProject()).getCachedValue((UserDataHolder)this, () -> CachedValueProvider.Result.create((Object)((Object)new ImplicitPersistenceUnit(this)), (Object[])JpaFacetImpl.getDependencies(this.getModule().getProject()))));
    }

    @NotNull
    private static Object[] getDependencies(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/facet/JpaFacetImpl", "getDependencies"));
        }
        Object[] objectArray = new Object[]{ProjectRootManager.getInstance((Project)project), FacetFinder.getInstance((Project)project).getAllFacetsOfTypeModificationTracker(JpaFacet.ID), PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/facet/JpaFacetImpl", "getDependencies"));
        }
        return objectArray;
    }

    @NotNull
    private List<PersistencePackage> getExtensionPersistenceUnits() {
        List list = ContainerUtil.concat((Object[])Extensions.getExtensions((ExtensionPointName)PersistencePackagesProvider.EP_NAME), provider -> provider.getPersistencePackages((PersistenceFacet)this));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/facet/JpaFacetImpl", "getExtensionPersistenceUnits"));
        }
        return list;
    }

    @NotNull
    public PersistenceMappings getEntityMappings(@NotNull PersistencePackage unit) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/jpa/facet/JpaFacetImpl", "getEntityMappings"));
        }
        assert (unit.isValid());
        this.refreshModel();
        Collection xmlMappings = PersistenceCommonUtil.getDomEntityMappings(com.intellij.javaee.model.xml.persistence.mapping.EntityMappings.class, (PersistencePackage)unit, (PersistenceFacet)this);
        EntityMappings annoMappings = this.getAnnotationEntityMappings(unit);
        if (annoMappings != null && xmlMappings.isEmpty()) {
            EntityMappings entityMappings = annoMappings;
            if (entityMappings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/facet/JpaFacetImpl", "getEntityMappings"));
            }
            return entityMappings;
        }
        ArrayList<PersistenceMappings> allMappings = new ArrayList<PersistenceMappings>(xmlMappings);
        if (annoMappings != null) {
            allMappings.add(0, (PersistenceMappings)annoMappings);
        }
        MergedPersistenceMappings mergedPersistenceMappings = allMappings.isEmpty() ? (PersistenceMappings)DomManager.getDomManager((Project)this.getModule().getProject()).createMockElement(com.intellij.javaee.model.xml.persistence.mapping.EntityMappings.class, this.getModule(), true) : new MergedPersistenceMappings((PersistenceFacet)this, allMappings);
        if (mergedPersistenceMappings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/facet/JpaFacetImpl", "getEntityMappings"));
        }
        return mergedPersistenceMappings;
    }

    @Nullable
    public EntityMappings getAnnotationEntityMappings(@NotNull PersistencePackage unit) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/jpa/facet/JpaFacetImpl", "getAnnotationEntityMappings"));
        }
        return this.myAnnotationsPersistenceRoot != null ? this.myAnnotationsPersistenceRoot.createCustomMappings((Condition<PsiClass>)((Condition)JpaFacetImpl.getAnnoMappingsCondition((PersistenceFacet)this, unit).getValue())) : null;
    }

    @NotNull
    public static CachedValue<Condition<PsiClass>> getAnnoMappingsCondition(PersistenceFacet facet, PersistencePackage unit) {
        CachedValue value = (CachedValue)unit.getUserData(ANNO_MAPPINGS_CONDITION);
        if (value == null) {
            value = CachedValuesManager.getManager((Project)facet.getModule().getProject()).createCachedValue(() -> {
                Condition<PsiClass> result = unit instanceof PersistenceUnit ? JpaFacetImpl.createAnnoMappingsCondition((PersistenceUnit)unit, facet.getModule()) : JpaFacetImpl.createAnnoMappingsConditionDefault(unit);
                return new CachedValueProvider.Result(result, new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }, false);
            unit.putUserData(ANNO_MAPPINGS_CONDITION, (Object)value);
        }
        CachedValue cachedValue = value;
        if (cachedValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/facet/JpaFacetImpl", "getAnnoMappingsCondition"));
        }
        return cachedValue;
    }

    private static Condition<PsiClass> createAnnoMappingsConditionDefault(PersistencePackage unit) {
        Collection classNames = GenericValueUtil.getClassStringCollection((Collection)unit.getModelHelper().getClasses(), (Collection)new THashSet());
        Collection packageNames = GenericValueUtil.getStringCollection((Collection)unit.getModelHelper().getPackages(), (Collection)new THashSet());
        Collection jarFiles = GenericValueUtil.getStringCollection((Collection)unit.getModelHelper().getJarFiles(), (Collection)new THashSet());
        if (EntityMappingsImpl.allEmpty(classNames, packageNames, jarFiles)) {
            if (Boolean.TRUE.equals(unit.getModelHelper().getExcludeUnlistedClasses().getValue())) {
                return Conditions.alwaysFalse();
            }
            return Conditions.alwaysTrue();
        }
        return EntityMappingsImpl.createUnitMappingsCondition(null, classNames, jarFiles, packageNames);
    }

    private static Condition<PsiClass> createAnnoMappingsCondition(PersistenceUnit unit, Module module) {
        Condition<PsiClass> result;
        boolean listedClasses = Boolean.TRUE.equals(unit.getExcludeUnlistedClasses().getValue());
        if (listedClasses || unit.getModule() == null) {
            Collection jarFiles;
            Collection classNames;
            if (listedClasses) {
                classNames = GenericValueUtil.getClassStringCollection((Collection)unit.getClasses(), (Collection)new THashSet());
                jarFiles = GenericValueUtil.getStringCollection((Collection)unit.getJarFiles(), (Collection)new THashSet());
                for (String jarFile : new ArrayList(jarFiles)) {
                    jarFiles.remove(jarFile);
                    jarFiles.add(jarFile.substring(jarFile.lastIndexOf(47) + 1));
                }
            } else {
                classNames = null;
                jarFiles = null;
            }
            result = EntityMappingsImpl.createUnitMappingsCondition(listedClasses ? null : JpaCommonUtil.getORMClassesSearchScope((Project)module.getProject(), (Module)module, (PsiFile)unit.getXmlTag().getContainingFile()), classNames, jarFiles, null);
        } else {
            result = Conditions.alwaysTrue();
        }
        return result;
    }

    public ConfigFileContainer getDescriptorsContainer() {
        return this.myDescriptorsContainer;
    }

    @NotNull
    public List<com.intellij.javaee.model.xml.persistence.mapping.EntityMappings> getDefaultEntityMappings(@NotNull PersistencePackage unit) {
        com.intellij.javaee.model.xml.persistence.mapping.EntityMappings defORMDescriptor;
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/jpa/facet/JpaFacetImpl", "getDefaultEntityMappings"));
        }
        ConfigFile ormDescriptor = this.getDefaultORMDescriptor();
        if (ormDescriptor == null) {
            PsiFile containingFile = unit.getContainingFile();
            VirtualFile xmlVf = containingFile == null ? null : containingFile.getVirtualFile();
            defORMDescriptor = PersistentUnitFileConverterImpl.findEntityMappings(JavaeeUtil.getDefaultDescriptorPath(JavaeePersistenceDescriptorsConstants.ORM_XML_META_DATA), xmlVf, PsiManager.getInstance((Project)this.getModule().getProject()), this.getModule());
        } else {
            defORMDescriptor = (com.intellij.javaee.model.xml.persistence.mapping.EntityMappings)JamCommonUtil.getRootElement((PsiFile)ormDescriptor.getXmlFile(), com.intellij.javaee.model.xml.persistence.mapping.EntityMappings.class, (Module)this.getModule());
        }
        if (defORMDescriptor != null) {
            List<com.intellij.javaee.model.xml.persistence.mapping.EntityMappings> list = Collections.singletonList(defORMDescriptor);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/facet/JpaFacetImpl", "getDefaultEntityMappings"));
            }
            return list;
        }
        List<com.intellij.javaee.model.xml.persistence.mapping.EntityMappings> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/facet/JpaFacetImpl", "getDefaultEntityMappings"));
        }
        return list;
    }

    @NotNull
    public Class<PersistenceUnit> getPersistenceUnitClass() {
        if (PersistenceUnit.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/facet/JpaFacetImpl", "getPersistenceUnitClass"));
        }
        return PersistenceUnit.class;
    }

    @NotNull
    public Map<ConfigFileMetaData, Class<? extends PersistenceMappings>> getSupportedDomMappingFormats() {
        Map<ConfigFileMetaData, Class<? extends PersistenceMappings>> map = Collections.singletonMap(JavaeePersistenceDescriptorsConstants.ORM_XML_META_DATA, com.intellij.javaee.model.xml.persistence.mapping.EntityMappings.class);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/facet/JpaFacetImpl", "getSupportedDomMappingFormats"));
        }
        return map;
    }

    public String getDataSourceId(@NotNull PersistencePackagePointer unit) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/jpa/facet/JpaFacetImpl", "getDataSourceId"));
        }
        return this.myUnitDataSourceMap.getSettingValue(unit.getElementName());
    }

    public String getDataSourceId(@NotNull PersistencePackage unit) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/jpa/facet/JpaFacetImpl", "getDataSourceId"));
        }
        return this.myUnitDataSourceMap.getDataSourceID(unit);
    }

    public void setDataSourceId(@NotNull PersistencePackage unit, String dataSourceID) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/jpa/facet/JpaFacetImpl", "setDataSourceId"));
        }
        this.myUnitDataSourceMap.setDataSourceID(unit, dataSourceID);
    }

    public Language getQlLanguage() {
        return JpaUtil.isHibernateProvider(this) ? JpqlLanguage.HQL : (JpaUtil.isEclipseLinkProvider(this) ? JpqlLanguage.EQL : JpqlLanguage.JPQL);
    }

    @NotNull
    public ModelValidator getModelValidator(@Nullable PersistencePackage unit) {
        PersistenceModelBrowser browser = PersistenceCommonUtil.createFacetAndUnitModelBrowser((PersistenceFacet)this, (PersistencePackage)unit, null);
        JpaModelValidatorBase jpaModelValidatorBase = unit instanceof PersistenceUnit && JpaUtil.isHibernateProvider((PersistenceFacet)this, unit) ? new HibernateModelValidator(browser) : new JpaModelValidator(browser);
        if (jpaModelValidatorBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/facet/JpaFacetImpl", "getModelValidator"));
        }
        return jpaModelValidatorBase;
    }

    @NotNull
    public Class[] getInspectionToolClasses() {
        Class[] classArray = new JpaInspectionToolProvider().getInspectionClasses();
        if (classArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/facet/JpaFacetImpl", "getInspectionToolClasses"));
        }
        return classArray;
    }

    @NotNull
    public PersistencePackageDefaults getPersistenceUnitDefaults(@NotNull PersistencePackage unit) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/jpa/facet/JpaFacetImpl", "getPersistenceUnitDefaults"));
        }
        assert (unit.isValid());
        CachedValue cachedValue = (CachedValue)unit.getUserData(PERSISTENCE_UNIT_DEFAULTS);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)unit.getPsiManager().getProject()).createCachedValue(() -> {
                if (unit == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/jpa/facet/JpaFacetImpl", "lambda$getPersistenceUnitDefaults$3"));
                }
                Collection mappings = PersistenceCommonUtil.getDomEntityMappings(com.intellij.javaee.model.xml.persistence.mapping.EntityMappings.class, (PersistencePackage)unit, (PersistenceFacet)this);
                String _schema = null;
                String _catalog = null;
                PropertyMemberType _access = null;
                for (Object mapping : mappings) {
                    PersistenceUnitDefaults defaults = mapping.getPersistenceUnitMetadata().getPersistenceUnitDefaults();
                    if (!DomUtil.hasXml((DomElement)defaults)) continue;
                    _schema = (String)defaults.getSchema().getValue();
                    _catalog = (String)defaults.getCatalog().getValue();
                    AccessType type = (AccessType)defaults.getAccess().getValue();
                    _access = type == null ? null : (type == AccessType.FIELD ? PropertyMemberType.FIELD : PropertyMemberType.GETTER);
                    break;
                }
                HashSet dependencies = ContainerUtil.newHashSet();
                dependencies.add(this.getModificationTracker());
                ContainerUtil.addIfNotNull((Collection)dependencies, (Object)unit.getContainingFile());
                for (com.intellij.javaee.model.xml.persistence.mapping.EntityMappings mapping : mappings) {
                    ContainerUtil.addIfNotNull((Collection)dependencies, (Object)mapping.getContainingFile());
                }
                final String schema = _schema;
                final String catalog = _catalog;
                final PropertyMemberType access = _access;
                PersistencePackageDefaults result = new PersistencePackageDefaults(){

                    @Nullable
                    public String getSchema() {
                        return schema;
                    }

                    @Nullable
                    public String getCatalog() {
                        return catalog;
                    }

                    @Nullable
                    public PropertyMemberType getAccess() {
                        return access;
                    }
                };
                return new CachedValueProvider.Result((Object)result, dependencies.toArray());
            }, false);
            unit.putUserData(PERSISTENCE_UNIT_DEFAULTS, (Object)cachedValue);
        }
        PersistencePackageDefaults persistencePackageDefaults = (PersistencePackageDefaults)cachedValue.getValue();
        if (persistencePackageDefaults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/facet/JpaFacetImpl", "getPersistenceUnitDefaults"));
        }
        return persistencePackageDefaults;
    }

    private void refreshModel() {
        List<PersistencePackage> allPersistenceUnits = this.getPersistenceUnits();
        if (allPersistenceUnits.size() > 0 || ApplicationManager.getApplication().isUnitTestMode()) {
            if (this.myAnnotationsPersistenceRoot == null) {
                this.myAnnotationsPersistenceRoot = new EntityMappingsImpl(this.getModule());
            }
        } else if (this.myAnnotationsPersistenceRoot != null) {
            this.myAnnotationsPersistenceRoot = null;
        }
    }

    public List<XmlFile> getPersistenceXmls() {
        XmlFile xmlFile = this.getPersistenceXmlInModule();
        List<XmlFile> files = this.findPersistenceXmlsInLibraries();
        if (xmlFile == null) {
            return files;
        }
        if (files.size() == 0) {
            return Collections.singletonList(xmlFile);
        }
        ArrayList<XmlFile> result = new ArrayList<XmlFile>(files.size() + 1);
        result.add(xmlFile);
        result.addAll(files);
        return result;
    }

    @Nullable
    public XmlFile getPersistenceXmlInModule() {
        XmlFile xmlFile;
        ConfigFile persistenceDescriptor = this.getMainDeploymentDescriptor();
        if (persistenceDescriptor != null && (xmlFile = persistenceDescriptor.getXmlFile()) != null) {
            return xmlFile;
        }
        return null;
    }

    public List<XmlFile> findPersistenceXmlsInLibraries() {
        Module module = this.getModule();
        if (this.myMyCachedXmls == null) {
            CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)module.getProject());
            this.myMyCachedXmls = cachedValuesManager.createCachedValue(() -> {
                VirtualFile[] files;
                ArrayList<XmlFile> resourceFiles = new ArrayList<XmlFile>();
                for (VirtualFile file : files = OrderEnumerator.orderEntries((Module)module).getAllLibrariesAndSdkClassesRoots()) {
                    PsiFile psiFile;
                    String tagNS;
                    VirtualFile candidate = file.findFileByRelativePath(JavaeeUtil.getDefaultDescriptorPath(JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA));
                    if (candidate == null || (tagNS = JavaeeUtil.getRootTagNS(psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(candidate), "persistence")) == null || tagNS.length() != 0 && !"http://java.sun.com/xml/ns/persistence".equals(tagNS)) continue;
                    resourceFiles.add((XmlFile)psiFile);
                }
                Object[] objects = resourceFiles.toArray();
                return new CachedValueProvider.Result(resourceFiles, ArrayUtil.append((Object[])objects, (Object)ProjectRootManager.getInstance((Project)module.getProject())));
            }, false);
        }
        return (List)this.myMyCachedXmls.getValue();
    }

    public static class UnitSettingMap {
        private final Map<PersistencePackage, String> myUnitNameMapping = new THashMap();
        private final Map<String, String> myConfigurationMap;
        private final PersistenceFacet myFacet;
        private long storedModificationCount = -1L;
        private final ReentrantReadWriteLock rw = new ReentrantReadWriteLock();
        private final ReentrantReadWriteLock.ReadLock r = this.rw.readLock();
        private final ReentrantReadWriteLock.WriteLock w = this.rw.writeLock();

        public UnitSettingMap(Map<String, String> configurationMap, PersistenceFacet facet) {
            this.myConfigurationMap = configurationMap;
            this.myFacet = facet;
        }

        public String getSettingValue(@NotNull PersistencePackage unit) {
            if (unit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/jpa/facet/JpaFacetImpl$UnitSettingMap", "getSettingValue"));
            }
            this.r.lock();
            try {
                this.refreshPersistenceUnits();
                String string = this.myConfigurationMap.get(this.getUnitNameWithCaching(unit));
                return string;
            }
            finally {
                this.r.unlock();
            }
        }

        public String getSettingValue(@NotNull String unitName) {
            if (unitName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unitName", "com/intellij/jpa/facet/JpaFacetImpl$UnitSettingMap", "getSettingValue"));
            }
            this.r.lock();
            try {
                this.refreshPersistenceUnits();
                String string = this.myConfigurationMap.get(unitName);
                return string;
            }
            finally {
                this.r.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSettingValue(@NotNull PersistencePackage unit, String dataSourceID) {
            if (unit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/jpa/facet/JpaFacetImpl$UnitSettingMap", "setSettingValue"));
            }
            this.w.lock();
            this.r.lock();
            try {
                String unitName = this.getUnitNameWithCaching(unit);
                if (StringUtil.isNotEmpty((String)unitName)) {
                    this.myConfigurationMap.put(unitName, dataSourceID);
                }
            }
            finally {
                this.r.unlock();
                this.w.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshPersistenceUnits() {
            ModificationTracker tracker = this.myFacet.getModificationTracker();
            if (this.storedModificationCount == tracker.getModificationCount()) {
                return;
            }
            this.r.unlock();
            this.w.lock();
            try {
                long modCount = tracker.getModificationCount();
                if (this.storedModificationCount == modCount) {
                    return;
                }
                this.storedModificationCount = modCount;
                ArrayList<PersistencePackage> unitsToRemove = new ArrayList<PersistencePackage>();
                ArrayList namesToRemove = new ArrayList();
                for (PersistencePackage unit : this.myUnitNameMapping.keySet()) {
                    if (unit.isValid()) continue;
                    unitsToRemove.add(unit);
                    ContainerUtil.addIfNotNull(namesToRemove, (Object)this.getCachedUnitName(unit));
                }
                for (PersistencePackage unit : this.myFacet.getPersistenceUnits()) {
                    assert (unit.isValid());
                    String prevName = this.getCachedUnitName(unit);
                    String unitName = this.getUnitNameWithCaching(unit);
                    if (StringUtil.isNotEmpty((String)prevName)) {
                        if (StringUtil.isNotEmpty((String)unitName)) {
                            if (Comparing.equal((String)prevName, (String)unitName)) continue;
                            this.myConfigurationMap.put(unitName, this.myConfigurationMap.remove(prevName));
                            continue;
                        }
                        this.myConfigurationMap.remove(prevName);
                        continue;
                    }
                    if (!StringUtil.isNotEmpty((String)unitName)) continue;
                    namesToRemove.remove(unitName);
                    this.myConfigurationMap.put(unitName, this.getSettingValueInner(unit));
                }
                this.myUnitNameMapping.keySet().removeAll(unitsToRemove);
                this.myConfigurationMap.keySet().removeAll(namesToRemove);
            }
            finally {
                this.r.lock();
                this.w.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private String getUnitNameWithCaching(PersistencePackage unit) {
            String s = this.getCachedUnitName(unit);
            if (s == null && StringUtil.isNotEmpty((String)(s = PersistencePackageAsVirtualFileImpl.getElementName(unit)))) {
                boolean wLocked = this.rw.isWriteLockedByCurrentThread();
                if (!wLocked) {
                    this.r.unlock();
                    this.w.lock();
                }
                try {
                    this.myUnitNameMapping.put(unit, s);
                }
                finally {
                    if (!wLocked) {
                        this.r.lock();
                        this.w.unlock();
                    }
                }
            }
            return s;
        }

        private String getCachedUnitName(PersistencePackage unit) {
            return this.myUnitNameMapping.get(unit);
        }

        @Nullable
        private String getSettingValueInner(PersistencePackage unit) {
            String name = this.myConfigurationMap.get(this.getUnitNameWithCaching(unit));
            if (name == null) {
                name = this.getDefaultSettingValue(unit);
            }
            return name;
        }

        @Nullable
        protected String getDefaultSettingValue(PersistencePackage unit) {
            return null;
        }
    }

    public static class UnitDataSourceMap
    extends UnitSettingMap {
        public UnitDataSourceMap(Map<String, String> configurationMap, PersistenceFacet facet) {
            super(configurationMap, facet);
        }

        public String getDataSourceID(@NotNull PersistencePackage unit) {
            if (unit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/jpa/facet/JpaFacetImpl$UnitDataSourceMap", "getDataSourceID"));
            }
            return this.getSettingValue(unit);
        }

        public void setDataSourceID(@NotNull PersistencePackage unit, String dataSourceID) {
            if (unit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/jpa/facet/JpaFacetImpl$UnitDataSourceMap", "setDataSourceID"));
            }
            this.setSettingValue(unit, dataSourceID);
        }

        @Override
        @Nullable
        protected String getDefaultSettingValue(PersistencePackage unit) {
            GenericValue value = unit.getModelHelper().getDataSourceName();
            return value != null ? (String)value.getValue() : null;
        }
    }
}

