/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.database.console.RemoteConsoleProcessSupport;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.jpa.engine.JpaConnectionManager;
import com.intellij.jpa.engine.JpaConsoleRunContext;
import com.intellij.jpa.remote.JpaFacade;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.util.EventDispatcher;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaConnectionManagerImpl
extends JpaConnectionManager {
    private final EventDispatcher<ModificationTrackerListener> myDispatcher = EventDispatcher.create(ModificationTrackerListener.class);
    private final RemoteConsoleProcessSupport<PersistencePackagePointer, JpaFacade> mySupport = new RemoteConsoleProcessSupport<PersistencePackagePointer, JpaFacade>(JpaFacade.class){

        protected void fireModificationCountChanged() {
            JpaConnectionManagerImpl.this.incModificationCount();
            ApplicationManager.getApplication().invokeLater(() -> ((ModificationTrackerListener)JpaConnectionManagerImpl.this.myDispatcher.getMulticaster()).modificationCountChanged((Object)JpaConnectionManagerImpl.this));
        }

        @NotNull
        protected ConsoleRunConfiguration.RunContext createRunContext(PersistencePackagePointer target) {
            JpaConsoleRunContext jpaConsoleRunContext = new JpaConsoleRunContext(target);
            if (jpaConsoleRunContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/engine/JpaConnectionManagerImpl$1", "createRunContext"));
            }
            return jpaConsoleRunContext;
        }

        protected String getName(PersistencePackagePointer file) {
            return ((VirtualFile)file).getName();
        }
    };

    public JpaConnectionManagerImpl(Project project) {
        Disposer.register((Disposable)project, this.mySupport);
    }

    @Override
    public List<ConsoleRunConfiguration> getActiveConfigurations(@NotNull PersistencePackagePointer unitFile) {
        if (unitFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unitFile", "com/intellij/jpa/engine/JpaConnectionManagerImpl", "getActiveConfigurations"));
        }
        return this.mySupport.getActiveConfigurations((Object)unitFile);
    }

    @Override
    public JpaFacade getConnection(@NotNull PersistencePackagePointer unitFile, @NotNull ConsoleRunConfiguration configuration) throws Exception {
        if (unitFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unitFile", "com/intellij/jpa/engine/JpaConnectionManagerImpl", "getConnection"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/jpa/engine/JpaConnectionManagerImpl", "getConnection"));
        }
        return (JpaFacade)this.mySupport.acquire((Object)unitFile, (Object)configuration);
    }

    @Override
    public void releaseConnection(@NotNull PersistencePackagePointer unitFile, @Nullable ConsoleRunConfiguration configuration) {
        if (unitFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unitFile", "com/intellij/jpa/engine/JpaConnectionManagerImpl", "releaseConnection"));
        }
        this.mySupport.release((Object)unitFile, (Object)configuration);
    }

    @Override
    public ModificationTracker getModificationTracker() {
        return this;
    }

    @Override
    public void addModificationTrackerListener(ModificationTrackerListener<JpaConnectionManager> listener, Disposable disposable) {
        this.myDispatcher.addListener(listener, disposable);
    }
}

