/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.actions;

import com.intellij.jpa.actions.GenerateJpaMappingAction;
import com.intellij.jpa.generation.DatabaseSchemaImporter;
import com.intellij.jpa.generation.EjbImporter;
import com.intellij.jpa.generation.HibernateImporter;
import com.intellij.jpa.generation.JpaMappingGenerator;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;

public class GenerateJpaMappingActionGroup
extends DefaultActionGroup
implements DumbAware {
    private static final Class[] ourImporterClasses = new Class[]{HibernateImporter.class, EjbImporter.class, DatabaseSchemaImporter.class};

    public void update(AnActionEvent event) {
        super.update(event);
        this.removeAll();
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
        if (facet != null) {
            for (Class generatorClass : ourImporterClasses) {
                JpaMappingGenerator generator;
                try {
                    Object instance = generatorClass.newInstance();
                    assert (instance instanceof JpaMappingGenerator);
                    generator = (JpaMappingGenerator)instance;
                }
                catch (Exception e) {
                    assert (false) : e;
                    continue;
                }
                if (!generator.isAvailableOnDataContext(dataContext)) continue;
                this.add(new GenerateJpaMappingAction(generator));
            }
        }
        boolean enabled = this.getChildrenCount() > 0;
        presentation.setEnabled(enabled);
        presentation.setVisible(enabled);
    }
}

