/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.javaee.model.xml.persistence.mapping.Entity;
import com.intellij.javaee.model.xml.persistence.mapping.RelationAttributeBase;
import com.intellij.jpa.JpaScopeModel;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.ql.QlFile;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.DomElementPattern;
import com.intellij.patterns.DomPatterns;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OrderByInXmlInjector
implements MultiHostInjector {
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/jpa/OrderByInXmlInjector", "getLanguagesToInject"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/jpa/OrderByInXmlInjector", "getLanguagesToInject"));
        }
        if (!(host instanceof XmlText) || host.getTextLength() == 0) {
            return;
        }
        PsiElement parent = host.getParent();
        if (!(parent instanceof XmlTag) || !"order-by".equals(((XmlTag)parent).getName())) {
            return;
        }
        XmlTag tag = (XmlTag)CompletionUtil.getOriginalOrSelf((PsiElement)((XmlTag)parent));
        DomElement dom = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
        if (dom instanceof GenericDomValue && StringUtil.isNotEmpty((String)((GenericDomValue)dom).getStringValue()) && ((DomElementPattern.Capture)DomPatterns.domElement(RelationAttributeBase.AnyToManyBase.class).withSuperParent(2, (ElementPattern)DomPatterns.domElement(Entity.class))).accepts((Object)dom.getParent())) {
            RelationAttributeBase attr = (RelationAttributeBase)dom.getParent();
            host.putUserData(QlFile.PERSISTENCE_MODEL_KEY, (Object)new JpaScopeModel(attr));
            registrar.startInjecting((Language)JpqlLanguage.JPQL);
            registrar.addPlace("select o from a b order by ", null, (PsiLanguageInjectionHost)host, OrderByInXmlInjector.getTrimmedRange(host, 0));
            registrar.doneInjecting();
        }
    }

    private static TextRange getTrimmedRange(PsiElement host, int strip) {
        int endOffset = host.getTextLength() - strip;
        String text = host.getText();
        String trimmed = text.substring(strip, endOffset).trim();
        return new TextRange(text.indexOf(trimmed, strip), endOffset);
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<XmlText>> list = Collections.singletonList(XmlText.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/OrderByInXmlInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

