/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaReadWriteAccessDetector
extends ReadWriteAccessDetector {
    public boolean isReadWriteAccessible(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/JpaReadWriteAccessDetector", "isReadWriteAccessible"));
        }
        PsiMember member = JpaReadWriteAccessDetector.getPsiMember(element);
        return member != null && JpaReadWriteAccessDetector.findDetector((PsiElement)member) != null;
    }

    public boolean isDeclarationWriteAccess(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/JpaReadWriteAccessDetector", "isDeclarationWriteAccess"));
        }
        PsiMember member = JpaReadWriteAccessDetector.getPsiMember(element);
        return JpaReadWriteAccessDetector.getDetectorSafe((PsiElement)member).isDeclarationWriteAccess((PsiElement)member);
    }

    @NotNull
    public ReadWriteAccessDetector.Access getReferenceAccess(@NotNull PsiElement referencedElement, @NotNull PsiReference reference) {
        if (referencedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedElement", "com/intellij/jpa/JpaReadWriteAccessDetector", "getReferenceAccess"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/jpa/JpaReadWriteAccessDetector", "getReferenceAccess"));
        }
        PsiMember member = JpaReadWriteAccessDetector.getPsiMember(referencedElement);
        ReadWriteAccessDetector.Access access = JpaReadWriteAccessDetector.getDetectorSafe((PsiElement)member).getReferenceAccess((PsiElement)member, reference);
        if (access == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaReadWriteAccessDetector", "getReferenceAccess"));
        }
        return access;
    }

    @NotNull
    public ReadWriteAccessDetector.Access getExpressionAccess(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/jpa/JpaReadWriteAccessDetector", "getExpressionAccess"));
        }
        for (ReadWriteAccessDetector detector : (ReadWriteAccessDetector[])Extensions.getExtensions((ExtensionPointName)EP_NAME)) {
            ReadWriteAccessDetector.Access access;
            if (detector instanceof JpaReadWriteAccessDetector || (access = detector.getExpressionAccess(expression)) == ReadWriteAccessDetector.Access.Read) continue;
            ReadWriteAccessDetector.Access access2 = access;
            if (access2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaReadWriteAccessDetector", "getExpressionAccess"));
            }
            return access2;
        }
        ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Read;
        if (access == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaReadWriteAccessDetector", "getExpressionAccess"));
        }
        return access;
    }

    @Nullable
    public static PsiMember getPsiMember(PsiElement element) {
        Object modelObject = JamCommonUtil.getModelObject((PsiElement)element);
        if (modelObject instanceof PersistentAttribute) {
            return ((PersistentAttribute)modelObject).getPsiMember();
        }
        return null;
    }

    @NotNull
    private static ReadWriteAccessDetector getDetectorSafe(PsiElement element) {
        ReadWriteAccessDetector readWriteAccessDetector = JpaReadWriteAccessDetector.findDetector((PsiElement)element);
        if (readWriteAccessDetector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaReadWriteAccessDetector", "getDetectorSafe"));
        }
        return readWriteAccessDetector;
    }
}

