/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.jpa.DefaultQlModel;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.ql.model.QlModel;
import com.intellij.jpa.ql.model.QlModelProvider;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaQlModelProvider
implements QlModelProvider {
    @Override
    @Nullable
    public QlModel getQlModel(@NotNull PsiElement s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/jpa/JpaQlModelProvider", "getQlModel"));
        }
        Language lang = s.getLanguage();
        if (lang != JpqlLanguage.JPQL && lang != JpqlLanguage.HQL && lang != JpqlLanguage.EQL) {
            return null;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)s.getProject()).getInjectionHost(s);
        PsiLanguageInjectionHost context = host != null ? host : s.getContext();
        PsiFile containingFile = (context == null ? s : context).getContainingFile();
        return new DefaultQlModel(lang == JpqlLanguage.HQL, containingFile);
    }
}

