/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetTypeId;
import com.intellij.jpa.view.editor.PersistencePackageAsVirtualFileImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.xml.DomElement;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JpaDataSourceDetectorBase<F extends Facet>
extends DataSourceDetector {
    private final FacetTypeId<F> myFacetTypeId;

    protected JpaDataSourceDetectorBase(@NotNull FacetTypeId<F> facetTypeId) {
        if (facetTypeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetTypeId", "com/intellij/jpa/JpaDataSourceDetectorBase", "<init>"));
        }
        this.myFacetTypeId = facetTypeId;
    }

    protected abstract Map<String, PairConsumer<DataSourceDetector.Builder, Properties>> getProviders();

    protected static PairConsumer<DataSourceDetector.Builder, Properties> provider(String urlProp, String userProp, String passwordProp, String driverProp) {
        return (builder, properties) -> {
            JpaDataSourceDetectorBase.collect(builder, DataSourceDetector.Property.URL, properties, urlProp);
            JpaDataSourceDetectorBase.collect(builder, DataSourceDetector.Property.USERNAME, properties, userProp);
            JpaDataSourceDetectorBase.collect(builder, DataSourceDetector.Property.PASSWORD, properties, passwordProp);
            JpaDataSourceDetectorBase.collect(builder, DataSourceDetector.Property.DRIVER_CLASS, properties, driverProp);
        };
    }

    private static void collect(@NotNull DataSourceDetector.Builder b, @NotNull DataSourceDetector.Property p, @NotNull Properties properties, @NonNls String keys) {
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/jpa/JpaDataSourceDetectorBase", "collect"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/jpa/JpaDataSourceDetectorBase", "collect"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/jpa/JpaDataSourceDetectorBase", "collect"));
        }
        for (String key : StringUtil.split((String)keys, (String)",", (boolean)true, (boolean)true)) {
            String property = properties.getProperty(key.trim());
            if (property == null) continue;
            b.with(p, property);
        }
    }

    public void collectDataSources(@NotNull Module module, @NotNull DataSourceDetector.Builder builder, boolean onTheFly) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jpa/JpaDataSourceDetectorBase", "collectDataSources"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/jpa/JpaDataSourceDetectorBase", "collectDataSources"));
        }
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)module.getProject());
        Collection facets = FacetManager.getInstance((Module)module).getFacetsByType(this.myFacetTypeId);
        for (Facet facet : facets) {
            for (PersistencePackage unit : ((PersistenceFacet)facet).getPersistenceUnits()) {
                PsiElement origin = unit instanceof DomElement ? ((DomElement)unit).getXmlElement() : unit.getIdentifyingPsiElement();
                String unitName = PersistencePackageAsVirtualFileImpl.getElementName(unit);
                DbDataSource existingDataSource = dbPsiFacade.findDataSource(((PersistenceFacet)facet).getDataSourceId(unit));
                String existingDataSourceName = existingDataSource == null ? null : existingDataSource.getName();
                DataSourceDetector.Callback callback = JpaDataSourceDetectorBase.newCallback((PersistenceFacet)facet, unit);
                Properties properties = unit.getModelHelper().getPersistenceUnitProperties();
                Map<String, PairConsumer<DataSourceDetector.Builder, Properties>> providers = this.getProviders();
                for (String provider : providers.keySet()) {
                    String dataSourceName = unitName + "/" + provider;
                    if (onTheFly && existingDataSourceName != null && !Comparing.equal((String)existingDataSourceName, (String)dataSourceName)) continue;
                    providers.get(provider).consume((Object)builder.withName(dataSourceName), (Object)properties);
                    builder.onCreate(callback).commit(provider, (Object)origin);
                }
            }
        }
    }

    @NotNull
    private static <F extends PersistenceFacet> DataSourceDetector.Callback newCallback(@NotNull F facet, @NotNull PersistencePackage unit) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/jpa/JpaDataSourceDetectorBase", "newCallback"));
        }
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/jpa/JpaDataSourceDetectorBase", "newCallback"));
        }
        final PersistencePackageAsVirtualFileImpl file = (PersistencePackageAsVirtualFileImpl)((Object)ObjectUtils.assertNotNull((Object)((Object)PersistencePackageAsVirtualFileImpl.findFile(unit, facet))));
        DataSourceDetector.Callback callback = new DataSourceDetector.Callback(){

            public void onCreated(@NotNull DatabaseSystem dataSource) {
                if (dataSource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/jpa/JpaDataSourceDetectorBase$1", "onCreated"));
                }
                Object facet = file.findFacet();
                PersistencePackage unit = file.findElement();
                if (facet instanceof PersistenceFacet && unit != null) {
                    ((PersistenceFacet)facet).setDataSourceId(unit, dataSource.getUniqueId());
                }
            }
        };
        if (callback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaDataSourceDetectorBase", "newCallback"));
        }
        return callback;
    }
}

