/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.framework;

import com.intellij.framework.FrameworkAvailabilityCondition;
import com.intellij.javaee.framework.JavaeeFrameworkVersionBase;
import com.intellij.javaee.framework.JavaeeProfileBasedFrameworkAvailabilityCondition;
import com.intellij.javaee.model.enums.WebAppVersion;
import com.intellij.util.descriptors.ConfigFileVersion;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WebFrameworkVersion
extends JavaeeFrameworkVersionBase {
    private WebAppVersion myWebXmlVersion;

    public WebFrameworkVersion(@NotNull WebAppVersion webXmlVersion) {
        if (webXmlVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webXmlVersion", "com/intellij/javaee/web/framework/WebFrameworkVersion", "<init>"));
        }
        this.myWebXmlVersion = webXmlVersion;
    }

    public static List<WebFrameworkVersion> getAllVersions() {
        ArrayList<WebFrameworkVersion> versions = new ArrayList<WebFrameworkVersion>();
        for (WebAppVersion version : WebAppVersion.values()) {
            versions.add(new WebFrameworkVersion(version));
        }
        return versions;
    }

    @NotNull
    public String getId() {
        String string = this.myWebXmlVersion.getValue();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/framework/WebFrameworkVersion", "getId"));
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myWebXmlVersion.getValue();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/framework/WebFrameworkVersion", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    public FrameworkAvailabilityCondition getAvailabilityCondition() {
        JavaeeProfileBasedFrameworkAvailabilityCondition javaeeProfileBasedFrameworkAvailabilityCondition = new JavaeeProfileBasedFrameworkAvailabilityCondition(this.myWebXmlVersion.getJavaeeVersion());
        if (javaeeProfileBasedFrameworkAvailabilityCondition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/framework/WebFrameworkVersion", "getAvailabilityCondition"));
        }
        return javaeeProfileBasedFrameworkAvailabilityCondition;
    }

    public boolean isWebXmlOptional() {
        return this.myWebXmlVersion.compareTo((Enum)WebAppVersion.WebAppVersion_3_0) >= 0;
    }

    @Override
    @NotNull
    public ConfigFileVersion getDescriptorVersion() {
        ConfigFileVersion configFileVersion = this.myWebXmlVersion.getConfigFileVersion();
        if (configFileVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/framework/WebFrameworkVersion", "getDescriptorVersion"));
        }
        return configFileVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.myWebXmlVersion == ((WebFrameworkVersion)o).myWebXmlVersion;
    }

    public int hashCode() {
        return this.myWebXmlVersion.hashCode();
    }
}

