/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.javaee.JavaeeCodeStyleSettings;
import com.intellij.javaee.NewAbstractDataHolder;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CreateClassUtil;
import org.jetbrains.annotations.Nullable;

public class ServletDataHolder
extends NewAbstractDataHolder {
    private String myJspFileName;
    private final boolean myShouldCreateClasses;

    public ServletDataHolder(Servlet source) {
        super(source.getModule(), WebUtil.getWebFacet((JavaeeModelElement)source).getRoot().getServlets(), (String)source.getServletName().getValue());
        this.setName((String)source.getServletName().getValue());
        this.setClassName(source.getServletClass().getStringValue());
        this.setJspFileName((String)source.getJspFile().getValue());
        this.myShouldCreateClasses = false;
    }

    public ServletDataHolder(WebFacet webFacet) {
        super(webFacet.getModule(), webFacet.getWebModel().getServlets(), null);
        this.setName(this.getUniqueName());
        this.setClassName(this.myCodeStyleSettings.SERVLET_CLASS_PREFIX + this.getName() + this.myCodeStyleSettings.SERVLET_CLASS_SUFFIX);
        this.setJspFileName(null);
        this.myShouldCreateClasses = true;
    }

    public String getJspFileName() {
        return this.myJspFileName;
    }

    public void setJspFileName(String jspFileName) {
        this.myJspFileName = jspFileName;
    }

    public boolean shouldCreateClasses() {
        return this.myShouldCreateClasses;
    }

    protected String getDefaultName() {
        return "Servlet";
    }

    protected String getObjectName(Object o) {
        return (String)((CommonServlet)o).getServletName().getValue();
    }

    public String getNamePrefix(JavaeeCodeStyleSettings settings) {
        return settings.SERVLET_DD_PREFIX;
    }

    public String getNameSuffix(JavaeeCodeStyleSettings settings) {
        return settings.SERVLET_DD_SUFFIX;
    }

    public final void installTo(Servlet servlet) {
        servlet.getServletName().setValue((Object)this.getName());
        servlet.getJspFile().setValue((Object)this.myJspFileName);
        servlet.getServletClass().setStringValue(this.getClassName());
        if (this.shouldCreateClasses()) {
            ServletDataHolder.createClass(this, "Servlet Class.java");
        }
    }

    @Nullable
    public static PsiClass createClass(NewAbstractDataHolder dataHolder, String template) {
        PsiClass existing = JavaPsiFacade.getInstance((Project)dataHolder.getModule().getProject()).findClass(dataHolder.getClassName(), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)dataHolder.getModule()));
        if (existing != null) {
            return existing;
        }
        return CreateClassUtil.createClassFromCustomTemplate((PsiDirectory)dataHolder.getClassDirectory(), (Module)dataHolder.getModule(), (String)dataHolder.getClassName(), (String)template);
    }
}

