/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.javaee.web.DeployedFileUrlConverter;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.jsp.WebDirectoryElement;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class DefaultDeployedFileUrlConverter
extends DeployedFileUrlConverter {
    @Override
    public Collection<String> getTargetPaths(@NotNull PsiFile sourceFile, @NotNull WebFacet webFacet) {
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/intellij/javaee/web/DefaultDeployedFileUrlConverter", "getTargetPaths"));
        }
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/javaee/web/DefaultDeployedFileUrlConverter", "getTargetPaths"));
        }
        WebDirectoryUtil directoryUtil = WebDirectoryUtil.getWebDirectoryUtil(sourceFile.getProject());
        WebDirectoryElement webDirectoryElement = directoryUtil.findWebDirectoryByFile(sourceFile.getVirtualFile(), webFacet);
        if (webDirectoryElement == null) {
            return null;
        }
        String path = webDirectoryElement.getPath();
        return Collections.singleton(path);
    }
}

