/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.util;

import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public abstract class CompatibleExternalizable<T>
implements JDOMExternalizable {
    @NonNls
    public static final String DATA_ELEMENT = "data";

    public void readExternal(Element element) throws InvalidDataException {
        Element dataElement = element.getChild(DATA_ELEMENT);
        if (dataElement == null) {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        } else {
            Object data = XmlSerializer.deserialize((Element)dataElement, this.getDataClass());
            if (data == null) {
                return;
            }
            this.readFromData(data);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        T data = this.createData();
        this.writeToData(data);
        Element dataElement = XmlSerializer.serialize(data, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        element.addContent(dataElement);
    }

    protected abstract Class<T> getDataClass();

    protected abstract T createData();

    protected abstract void readFromData(T var1);

    protected abstract void writeToData(T var1);
}

